function Abar = uncirc(A,k)
% UNCIRC Transform a circulant matrix (or matrix of circulants) into a camat
%
% Example:
%   A = carand(2,3,3);
%   C = circ(A); % convert to a matrix
%   A2 = uncirc(C,size(A,3)) % convert back a camat
%   A-A2

assert(mod(size(A,1),k) == 0)
assert(mod(size(A,2),k) == 0)

D = zeros(k,size(A,2)/k,size(A,1)/k);
for j = 1:size(D,2)
    for i = 1:size(D,3)
        D(:,j,i) = A(k*(i-1)+1:k*i,k*(j-1)+1);
    end
end
Abar = camat(D);

