% need Kilmer directory on path for test
cd kilmer
addpath(pwd)
cd ..

% run test

A = reshape(1:24,4,2,3);
v = reshape(-1:-1:-8,4,1,2);
Ar = permute(A,[3,2,1]);
vr = permute(v,[3,1,2]);
zr = tmprod(permute(A,[3,2,1]), permute(v,[3,1,2]));
Af = fft(A);
vf = fft(v);

B = camat(A);
w = camat(v);

Bw = B*w;
absdiff = @(x,y) sum(abs(x(:)-y(:)));
assert(absdiff(ipermute(zr,[3,1,2]),data(Bw))<eps, 'failed mat-vec prod');


% Construct a square A
A2 = rand(3,4,4);
B2 = camat(A2);
A2r = permute(A2,[3,2,1]);
Asq = ttprod(A2r,A2r);
Bsq = B2*B2;
assert(absdiff(ipermute(Asq,[3,2,1]),data(Bsq))<110*eps, 'failed mat-mat prod')

% access tests
mt = 2;
nt = 3;
kt = 4;
Bmat = reshape(1:mt*nt*kt, kt, nt, mt);
B = camat(Bmat);
assert(absdiff(data(B(2,1)),[13 14 15 16]) == 0, 'failed scalar element check');
assert(B(1,2,3) == 7, 'failed real element check');
assert(absdiff(data(B(:)),reshape(Bmat,kt,mt*nt))<100*eps, 'failed vectorize access');

% assign tests
m = 5;
n = 3;
k = 4;
B = cazeros(m,n,k);
B(4,2,3) = 1;
assert(B(4,2,3) == 1, 'failed setting real');
assert(absdiff(data(B(4,2)),[0 0 1 0]) == 0, 'failed setting real');
B(2,3) = cascalar([ 5 6 7 8]);
assert(absdiff(data(B(2,3)),[5 6 7 8]) == 0, 'failed setting scalar');
bcolm = reshape(1:m*k,k,1,m);
bcol = camat(bcolm);
B(:,1) = bcol;
assert(absdiff(data(B(:,1)),data(bcol)) == 0, 'failed setting column');
B(1,1) = 0; % clears an element
bcolm(1:k) = 0;
assert(absdiff(data(B(:,1)),bcolm) == 0, 'failed zeroing element');
B(1,1) = pi; % clears an element
bcolm(1) = pi;
assert(absdiff(data(B(:,1)),bcolm) == 0, 'failed setting real element');

% size functions
mt = 2;
nt = 3;
kt = 4;
B = camat(reshape(1:mt*nt*kt, kt, nt, mt));
m = size(B,1); assert(mt==m, 'failed size 1');
n = size(B,2); assert(nt==n, 'failed size 2');
k = size(B,3); assert(kt==k, 'failed size 3');
[m1,n1] = size(B); assert(m1==m & n1==n, 'failed size');

% svd function
A = carand(5,5,3);
[U,S,V] = svd(A);
D = U*S*V' - A;
assert(mag(norm(D)) < 1e-12, 'failed svd');

A = carand(5,7,3);
[U,S,V] = svd(A);
D = U*S*V' - A;
assert(mag(norm(D)) < 1e-12, 'failed svd');

A = cazeros(3,2,6);
A(1,1) = 1;
[U,S,V] = svd(A);
assert(mag(norm(U-caeye(3,3,6)))< 1e-12, 'failed svd');
assert(mag(norm(V-caeye(2,2,6)))< 1e-12, 'failed svd');
assert(mag(norm(A-S))<1e-12, 'failed svd');



% circ function
A = circ(carand(5,7,3));
A = circ(caeye(5,5,3));
assert(isequal(A,eye(5*3,5*3)));

% qr 
A = carand(5,8,4);
[Q,R] = qr(A);
assert(mag(norm(A-Q*R))<1e-12, 'failed qr');

A = carand(8,3,15);
[Q,R] = qr(A);
assert(mag(norm(A-Q*R))<1e-12, 'failed qr');




