function MA = bcirc(M,k)
% BCIRC Construct a block circulant matrix 
% BC = bcirc(M,k) returns an m*k-by-n*k block circulant matrix from an 
% m*k-by-n matrix M.  

mk = size(M,1);
n = size(M,2);
m = floor(mk/k);
if mod(mk,k) ~= 0,
    error ('dimension mismatch mk != m*k, check row size of input');
end

MA = zeros(m*k,n*k);

% build subscripts for the circulant structure so we can just copy data in
% by it's id
cidx = [0 k-1:-1:1];
ridx = 0:k-1;

% There are k blocks of m, and we need 

for i=1:k
    for j=1:k
        ri = ridx(i)+1;
        ci = cidx(j)+1;
        idx = mod(cidx(j) + ridx(i),k)+1;
        blk = M((idx-1)*m+1:(idx)*m,:);
        %k*(ri-1)+1:(k)*ri
        %k*(ci-1)+1:(k)*ci
        MA(m*(i-1)+1:(m)*i,n*(j-1)+1:(n)*j) = blk;
        %MA(i,j) = idx;
    end
end
