%% Explore the power method in the circulant algebra
% In this experiment, we consider simple 2x2 matrices where we fixed the
% eigenvalues and explore the power method in the algebra.

%% Check that our power method is correct
k = 3;
A = cazeros(2,2,k);
A(1,1) = 2;
A(2,2) = 1;
[x,lambda] = cpowermtd(A);
lambda

%%
% Which is correct!

x'

%%
% Which is strange, but actually good...
% Recall that an eigenvector is unique up to scaling and sign.  The
% normalization fixes the scaling, but not the sign.  In the circulant
% algebra the notion of sign generalizes to any unitary matrix.
% Let's look at the relationship.

% set y to the intuitive eigenvector
y = cazeros(2,1,k);
y(1,1,1) = 1;

s = y(1)./x(1);

circ(data(s))'*circ(data(s))



%% 
% Excellent!  It is unitary/orthogonal as expected.
% This point raises the question:
%   should we normalize all eigenvectors so that x(1) is 
%   always real and positive?
%

%% Moving to circulants.
% Let's repeat this experiment with circulants.
% This experiment doesn't show anything too surprising, we get geometric
% convergence and converge to something like [1,0,0]
A = cazeros(2,2,k);
A(1,1) = cascalar([2,1,1]);
A(2,2) = cascalar([1,1,1]);

[x,lambda,hist] = cpowermtd(A);
lambda
semilogy(hist);
x'

%% A more interesting case
% In this case, we have the same situtation and fix an obvious starting
% vector.
k=3;
A = cazeros(2,2,k);
A(1,1) = cascalar([2,3,1]);
A(2,2) = cascalar([3,1,1]);
y = cazeros(2,1,k); y(1) = 1;
[x,lambda] = cpowermtd(A,y);
lambda
rats(data(x'))

%% A really interesting case
% Here, we work with the same matrix as in the last case, but, let's look
% at the eigenvalue we compute
[x,lambda,hist] = cpowermtd(A);
lambda
x'

%%
% Woah, what is that? Let's make sure it's correct.
(A*x - lambda*x)'

%%
% For more about this case, check the eigenvalues.m file where we begin
% with an analysis of this case and explain what happens.


%% Other examples:

k = 6;
A = cazeros(2,2,k);
A(1,1) = cascalar([2,3,1,1,1,1]);
A(2,2) = cascalar([3,1,1,1,1,1]);
% check relative magnitude
mag(A(1,1)./A(2,2))
mag(A(2,2)./A(1,1))
% compute lambda from my expression
D = data(diag(A));
Dhat = fft(D);
lhat = max(Dhat,[],2); % take the max along rows
test_lambda = ifft(lhat)
% compute lambda via the power method
[x,lambda,hist] = cpowermtd(A);
lambda
x'


%%

A = carand(2,2,10);
A(1,2) = 0;
A(2,1) = 0;
[x,lambda,hist] = cpowermtd(A);

%% Try random cases

k = 7;
A = carandn(2,2,k);
A(1,2) = 0;
A(2,1) = 0;
[x,lambda,hist] = cpowermtd(A);

mag(A(1,1)./A(2,2))
mag(A(2,2)./A(1,1))

%% See what happens with deflation
% Start with our standard example.
k=3;
A = cazeros(2,2,k);
A(1,1) = cascalar([2,3,1]);
A(2,2) = cascalar([3,1,1]);
[x,lambda] = cpowermtd(A);
lambda
%%
% Deflate the eigenvalue
B = A - lambda*diag(caones(2,1,k));
[y,lambda2] = cpowermtd(B);
lambda2
(A*y - lambda2*y)'
(B*
%%
C = A-lambda2*diag(caones(2,1,k));
