function h=plotcirc(x,varargin)
% PLOTCIRC Plot a circulant in polar coordinates as t

% 2009-12-03: Initial coding

X = data(x);
n = numel(x);
k = size(x,3);
theta = 2*pi*(0:k)./k;
theta = repmat(theta',1,n);
rho = reshape(X,k,n);
rho = [rho; rho(1,:)];
h=polar(theta,rho,varargin{:});
