%% Expore the magnitude of circulant elements
% We want to check what functions define valid magnitudes.  A simple
% property to verify is that g(A*B) \le g(A)*g(B).  We check that for a few
% functions in this script.

k = 2; % dimension of the circulant vector.
ntrials = 10;

f = @(x) norm(x,2);
%f = @(x) norm(circ(x),2);
for i=1:ntrials
    a = randn(k,1);
    b = randn(k,1);
    c = circ(a)*b;
    delta = f(a)*f(b) - f(c)
    if delta<0
        [a b c; f(a) f(b) f(c)]
    end
end