%% Properties of the circulant inner product

k = 4;
n = 6;
X = randn(k,n);
Y = randn(k,n);
C = camat(reshape(X,k,n,1));
D = camat(reshape(Y,k,n,1));

norm22 = @(X) ifft(sum(fft(data(X)).^2,2))
norm2 = @(X) ifft(sqrt(sum(fft(data(X)).^2,2)))
normabs22 = @(X) ifft(sum(abs(fft(data(X))).^2,2))
normabs2 = @(X) ifft(sqrt(sum(abs(fft(data(X))).^2,2)))



C*C'
norm22(C)
sqrt(C*C')
norm2(C)

normabs2(C)
norm(C,2)
norm(C,2)*norm(C,2)
normabs22(C)

%%
norm3 = @(X) ifft(diag(fft(data(X))*fft(data(X))'));
norm3(C)

%% 
% See if we should throw a conjugate in here

f = [1 -1i 0 1i];
a = ifft(f);
b = ifft(conj(f));
F = 1./sqrt(4)*fft(eye(4)); % so the F^2 matrix gives the right thing here..


