%% Experiment with the infinity norm 
% Initial experiments with the infinity norm indicate it is 
% either the mean of the largest element, or the element with largest mean.

%% Setup
% Generate some functions to make my life easier!
mat2ten1 = @(x) camat(reshape(x,size(x,1),1,size(x,2)));
mat2ten2 = @(x) camat(reshape(x,size(x,1),size(x,2),1));

normconv = @(A1,k) ....
    cell2mat(...
        arrayfun(@(p) reshape(data(norm(A1,p)),size(A1,3),1),1:k,...
            'UniformOutput',false));


%% Simple integer cases
Adata = [0 1 2 3 
         4 5 6 7
         8 9 10 11];

A1 = mat2ten2(Adata);
norm(A1,50) % seems to be the mean
plot(normconv(A1,50)'); % interesting convergence bump at 35

%%
Adata = [ 1  2  5 -10
          0  1  6 -11
         -1 -3  7 -12];
A1 = mat2ten2(Adata);
norm(A1,50) % seems to be the mean
plot(normconv(A1,50)'); % interesting convergence bump at 20

%%
Adata = [ 1  2
          0  1
         -1  -3];
A1 = mat2ten2(Adata);
n= norm(A1,100) % not the mean!
plot(normconv(A1,50)'); % just very rapid convergence
abs(fft(data(A1)))
fft(data(n)) % we get the max element in abs space

%%
Adata = [1 2 3 4
         0 0 0 0
         0 0 0 0];
A1 = mat2ten2(Adata);
n = norm(A1,50)
plot(normconv(A1,50)'); % just very rapid convergence

%%
Adata = [1 2 3 4
         4 0 0 0
         -1 -2 -3 -4];
A1 = mat2ten2(Adata);
n = norm(A1,50)
norm(A1,Inf)
plot(normconv(A1,50)'); % just very rapid convergence
abs(fft(data(A1)))
fft(data(n))

% aha!  It's the ifft of the max element from each coordinate!

%% Testing the hypothesis
% According to the preivous hypothesis, the Infinity norm is
ifft(max





     
     



        