%% Generate plots

load 'results'

Fplot = F1;
Fplot(~isfinite(Fplot)) = -1;
[i,j,v] = find(Fplot+1); v=v-1;
scatter(testsizes(i),testnonzeros(j),24,v,'filled');
set(gca,'XScale','log'); set(gca,'YScale','log'); xlabel('size');  ylabel('nonzeros');
colormap(copper);
h = colorbar;
set(h,'YTickLabel',{'circmult','fft'})
set(h,'YTick',[0 nrep]);

print 'simple-fft.eps' -depsc2

Fplot = F2;
Fplot(~isfinite(Fplot)) = -1;
[i,j,v] = find(Fplot+1); v=v-1;
scatter(testsizes(i),testnonzeros(j),24,v,'filled');
set(gca,'XScale','log'); set(gca,'YScale','log'); xlabel('size');  ylabel('nonzeros');
colormap(copper);
h = colorbar;
set(h,'YTickLabel',{'circmult','fft'})
set(h,'YTick',[0 nrep]);

print 'fair-fft.eps' -depsc2

