%%
addpath('../../');
maxNumCompThreads(1);


%%
nsizes = 32;
nsparsity = 32;
nrep = 64;
nvecs = 1;

testsizes = unique(ceil(logspace(1.5,5,nsizes)));
testnonzeros = unique(ceil(logspace(0.5,3,nsparsity)));
nsizes = length(testsizes);
nsparsity = length(testnonzeros);
errtol = 1e-10;

%% 
F1 = NaN*zeros(nsizes,nsparsity); % counts number of times fft was faster
F2 = NaN*zeros(nsizes,nsparsity); % counts number of times cached fft was faster
for si=1:nsizes
    t0 = tic;
    k = testsizes(si);
    fprintf('size %i (%i/%i)\n',k, si, nsizes);
    for pi=1:nsparsity
        p = testnonzeros(pi);
        fprintf('sparsity %i (%i/%i)\n', p , pi, nsparsity);
        if p>k
            % these have too many non-zeros
            continue
        end
        F1(si,pi) = 0;
        F2(si,pi) = 0;
        for ri=1:nrep+1
            %%
            X = randn(k,nvecs);
            a = sprandn(k,1,p/k);
            [f1,fY1] = fftmult_time(a,X);
            [f2,fY2] = fftmult_fast_time(a,X);
            [c1,cY1] = circmult_time_1(a,X);
            [c2,cY2] = circmult_time_2(a,X);
            if norm(fY1-fY2,'fro')>errtol ...
                    || norm(fY2-cY1,'fro')>errtol ...
                    || norm(cY1-cY2,'fro')>errtol ...
                    || norm(cY2-fY1,'fro')>errtol
                warning('inaccurate results');
            end
            if ri>1
                if f1<min(c1,c2)
                    F1(si,pi) = F1(si,pi)+1;
                end
                if f2<min(c1,c2)
                    F2(si,pi) = F2(si,pi)+1;
                end
            end
        end
        save 'results.mat' si pi F1 F2 testsizes testnonzeros nrep nvecs
    end
    dt = toc(t0);
    fprintf('end size %.1f\n',dt);
end
