%% Examine eigenvectors
% Generate a random integer matrix and compute one set of eigenvalues and
% eigenvectors.

n = 3;
k = 2;
A = carandi([-5,5],n,n,k);
A = A./2 + A'./2;
% diagonalize A
[V,D] = eig(A);
V
D

%%
% check that these things are 0
for i=1:n
    res = max(max(abs(data(A*V(:,i) - V(:,i)*D(i,i)))));
    fprintf('Residual of eigenvalue/vector %3i: %g\n', i, res);
end

%% Build the complete set
% In this step, we build all n^k eigenvalues and eigenvectors.
type analyze_eigenvalues_vectors.m
%%
[Vf,Df,Pf] = analyze_eigenvalues_vectors(A);
diag(Df)
%%
% check that these things are 0
for i=1:size(Df,1)
    res = max(max(abs(data(A*Vf(:,i) - Vf(:,i)*Df(i,i)))));
    fprintf('Residual of eigenvalue/vector %3i: %g\n', i, res);
end
%% Examine eigenvector/eignevalue structure
% the matrix P encodes the choice of coefficients in the eigenvalues.
Pf(:,1)
%%
% Given a diagonalization D, this means that we use the two Fourier
% coefficients of the first component of D.
Pf(:,2)
%%
% Given the same diagonalization, this means that we use the second Fourier
% coefficients from D(1,1) and the first Fourier coefficient of D(2,2).
%
% Let's look at them all..
Pf
%% Spanning sets
% Now let's look at which subsets of Vf (the entire n^k set of
% eigenvectors) constitute a spanning space...
%
% Based on the structure of P, it seems like if we take a subset where
% there is a "1" in each row, then we'll get a spanning space. 
% So let's see what happens if we pick a subset without a "1" in each row.

subset = [2,3,4];
Ps = Pf(:,subset);
Vs = Vf(:,subset);
Ds = diag(Df(subset,subset));
Ps
%%
% Vs is not an orthogonal set
Vs'*Vs
%%
Vs*Vs'
%%
% Is Vs a linearly independent set of vectors?
sigmas = svd(Vs)
%%
% This appears to be non-singular, but let's try...
% Look at the product of the singular values
prod_sigmas = sigmas(1);
for i=2:n
    prod_sigmas = prod_sigmas*sigmas(i);
end
prod_sigmas
%%
% It still looks non-singular, but not in the eigenvalue space...
fft(data(prod_sigmas))
%%
% So, is this matrix singular or non-singular?  I guess we need to work out
% what it means to be singular in this algebra.  
% Can I exhibit a null-vector?
AV = A*Vs;
z = cazeros(n,1,k);
for i=1:n
    z = z + AV(:,i)*sigmas(i);
end
z
%%
% Hmm... I thought z might be a 0 vector, but I guess not.  I'll have to
% think more about how to get a null-vector out of an SVD when you odn't
% have "0"'s to indicate which vectors are 0 :-).
