%% Explore eigenvectors in the circulant algebra
% While developing our theory, we tested a few hypotheses about
% eigenvectors.

%% Start with our interesting case
% We got started by trying to explain the following eigenvalue/eigenvector
% pair from the power method.
k=3;
A = cazeros(2,2,k);
A(1,1) = cascalar([2,3,1]);
A(2,2) = cascalar([3,1,1]);

%% 
% This matrix is diagonal, so build all it's eigenvalues and eigenvectors
% from our characterization in the EIGENVALUES file.
% Let's look at the FFTs of x(1), x(2) and lambda, along with the FFT of
% A(1,1) and A(2,2)
Bhat = fft(data(A(1,1)));
Chat = fft(data(A(2,2)));

[Bhat Chat]

%% 
% the eigenvectors for these should be

ltest = cascalar(ifft([Bhat(1), Bhat(2), Bhat(3)]))
xhat = [1 1 1]'; yhat = [0 0 0]';
xtest = camat(reshape([ifft(xhat); ifft(yhat)], k, 1, 2));
(A*xtest - ltest*xtest)'
x1 = xtest;

%%
ltest = cascalar(ifft([Bhat(1), Chat(2), Chat(3)]))
xhat = [1 0 0]'; yhat = [0 1 1]';
xtest = camat(reshape([ifft(xhat); ifft(yhat)], k, 1, 2));
(A*xtest - ltest*xtest)'
x2 = xtest;

%%
ltest = cascalar(ifft([Chat(1), Chat(2), Chat(3)]))
xhat = [0 0 0]'; yhat = [1 1 1]';
xtest = camat(reshape([ifft(xhat); ifft(yhat)], k, 1, 2));
(A*xtest - ltest*xtest)'
x3 = xtest;

%%
ltest = cascalar(ifft([Chat(1), Bhat(2), Bhat(3)]))
xhat = [0 1 1]'; yhat = [1 0 0]';
xtest = camat(reshape([ifft(xhat); ifft(yhat)], k, 1, 2));
(A*xtest - ltest*xtest)'
x4 = xtest;

%% Look at determinants of these examples
ltest = cascalar(ifft([Bhat(1), Bhat(2), Bhat(3)]))
(A(1,1)-ltest)*(A(2,2)-ltest)
ltest = cascalar(ifft([Bhat(1), Chat(2), Chat(3)]))
(A(1,1)-ltest)*(A(2,2)-ltest)
ltest = cascalar(ifft([Chat(1), Chat(2), Chat(3)]))
(A(1,1)-ltest)*(A(2,2)-ltest)
ltest = cascalar(ifft([Chat(1), Bhat(2), Bhat(3)]))
(A(1,1)-ltest)*(A(2,2)-ltest)


%% Try random cases

k = 7;
A = carandn(2,2,k);
A(1,2) = 0;
A(2,1) = 0;

%%
% test conjecture about other eigenvalues
jpick = ceil((k+1)/2);
n = size(A,1);
% lets use our subset enumerate to pick out which eigenvalue we choose in
% each location
% we have n choices for each of the jpick locations
bins = n*ones(1,jpick);
cur = subset_enumerate(bins);
while cur ~= 0
    %fprintf('[ '); fprintf('%i ', cur); fprintf(']\n');
    % build ltest from cur
    lhat = zeros(k,1);
    lhat(1) = Dhat(1,cur(1));
    if mod(k,2) == 0
        lhat(end) = Dhat(end,cur(end));
    end
    % 2:jpick includes the last position, which we don't want if k is even
    % so 2:jpick-1 excludes the last position, unless mod(k,2)==1 (when k
    % is odd), so this gives us the right range.
    for j=2:(jpick-1+mod(k,2)) % use the last position 
        lhat(j) = Dhat(j,cur(j));
        lhat(k-j+2) = Dhat(k-j+2,cur(j));
    end
    ltest = cascalar(ifft(lhat));
    curdet = caones(1,1,k);
    % now compute the determinant
    for i=1:n
        curdet = curdet*(A(i,i)-ltest);
    end
    fprintf('[ '); fprintf('%6.4f ', data(ltest)); fprintf(']\n');
    %data(ltest)'
    fprintf('||det|| = %g\n', norm(data(curdet)));
    cur = subset_enumerate(cur,bins);
end

%% Try a 4x4 example
k=2;
n=4;
A = carandn(n,n,k);
A = diag(diag(A));
[x,lambda,hist] = cpowermtd(A);
%%
% Repeat the same analysis to
% test conjecture about other eigenvalues
D = data(diag(A));
Dhat = fft(D);
lhat = max(Dhat,[],2); % take the max along rows
test_lambda = ifft(lhat)
lambda

jpick = ceil((k+1)/2);
n = size(A,1);
% lets use our subset enumerate to pick out which eigenvalue we choose in
% each location
% we have n choices for each of the jpick locations
bins = n*ones(1,jpick);
cur = subset_enumerate(bins);
while cur ~= 0
    %fprintf('[ '); fprintf('%i ', cur); fprintf(']\n');
    % build ltest from cur
    lhat = zeros(k,1);
    lhat(1) = Dhat(1,cur(1));
    if mod(k,2) == 0
        lhat(end) = Dhat(end,cur(end));
    end
    % 2:jpick includes the last position, which we don't want if k is even
    % so 2:jpick-1 excludes the last position, unless mod(k,2)==1 (when k
    % is odd), so this gives us the right range.
    for j=2:(jpick-1+mod(k,2)) % use the last position 
        lhat(j) = Dhat(j,cur(j));
        lhat(k-j+2) = Dhat(k-j+2,cur(j));
    end
    ltest = cascalar(ifft(lhat));
    curdet = caones(1,1,k);
    % now compute the determinant
    for i=1:n
        curdet = curdet*(A(i,i)-ltest);
    end
    fprintf('[ '); fprintf('%6.4f ', data(ltest)); fprintf(']\n');
    %data(ltest)'
    fprintf('||det|| = %g\n', norm(data(curdet)));
    cur = subset_enumerate(cur,bins);
end


%%
% see what happens if we try ALL possibilities...
k=4;
n=4;
A = carandn(n,n,k);
A = diag(diag(A));
D = data(diag(A));
Dhat = fft(D);

jpick = k;
n = size(A,1);
% lets use our subset enumerate to pick out which eigenvalue we choose in
% each location
% we have n choices for each of the jpick locations
bins = n*ones(1,jpick);
cur = subset_enumerate(bins);
while cur ~= 0
    for j=1:jpick % use the last position 
        lhat(j) = Dhat(j,cur(j));
    end
    ltest = cascalar(ifft(lhat));
    curdet = caones(1,1,k);
    % now compute the determinant
    for i=1:n
        curdet = curdet*(A(i,i)-ltest);
    end
    fprintf('[ '); fprintf('%6.4f ', data(ltest)); fprintf(']\n');
    %data(ltest)'
    fprintf('||det|| = %g\n', norm(data(curdet)));
    cur = subset_enumerate(cur,bins);
end

%%
n = 3;
k = 2;
A = carandi([-5,5],n,n,k);
A = A./2 + A'./2;
% diagonalize A
[V,D] = eig(A);
% now look at different eigenvalues
Dhat = fft(data(diag(D)));
jpick = k;
n = size(A,1);
% lets use our subset enumerate to pick out which eigenvalue we choose in
% each location
% we have n choices for each of the jpick locations
bins = n*ones(1,jpick);
cur = subset_enumerate(bins);
while cur ~= 0
    Lvis = zeros(n,jpick);
    for j=1:jpick % use the last position 
        lhat(j) = Dhat(j,cur(j));
        Lvis(cur(j),j)=1;
    end
    Lvis
    ltest = cascalar(ifft(lhat));
    curdet = caones(1,1,k);
    % now compute the determinant
    for i=1:n
        curdet = curdet*(D(i,i)-ltest);
    end
    fprintf('[ '); fprintf('%6.4f ', data(ltest)); fprintf(']\n');
    %data(ltest)'
    fprintf('||det|| = %g\n', norm(data(curdet)));
    cur = subset_enumerate(cur,bins);
end
%%
% We now build the complete eigenvalue, eigenvector matrix
n = size(A,1);
% lets use our subset enumerate to pick out which eigenvalue we choose in
% each location
% we have n choices for each of the jpick locations
bins = n*ones(1,jpick);
cur = subset_enumerate(bins);
while cur ~= 0
    Lvis = zeros(n,jpick);
    for j=1:jpick % use the last position 
        lhat(j) = Dhat(j,cur(j));
        Lvis(cur(j),j)=1;
    end
    Lvis
    ltest = cascalar(ifft(lhat));
    curdet = caones(1,1,k);
    % now compute the determinant
    for i=1:n
        curdet = curdet*(D(i,i)-ltest);
    end
    fprintf('[ '); fprintf('%6.4f ', data(ltest)); fprintf(']\n');
    %data(ltest)'
    fprintf('||det|| = %g\n', norm(data(curdet)));
    cur = subset_enumerate(cur,bins);
end
