%% Debug the SVD
% When implementing the SVD, I discovered that copying the implementation
% from Kilmer et al. had the wrong data organization for our
% implementation.  Thus, I wanted to suss out what the issue was.

%% Setup and the problem
% Load a simple matrix
A = cazeros(4,4,3);
A(1,2) = 1;
A(2,2) = 1;
A

%%
% Look at the initial SVD
type svd_initial.m

%%
% See the problem
[U,S,V] = svd_initial(A);
U*S*V'
%%
% This matrix has the 1 in the wrong place, but we can fix it.
V'*S*U
%%
% We need to reverse the order for some reason, let's figure out why.

%% Studying the block-matrix
% Let's look at a block-diagonal form
A2 = carand(4,4,3); % another matrix to study for some cases
k = size(A,3);
n = size(A,1);
F = fft(eye(k))./sqrt(k);
C = circ(A);
bigF = kron(eye(n),F);
D = bigF*C*bigF'
%%
% Permute to a block-diagonal matrix
p = reshape(1:n*k,k,n)';
P = sparse(1:n*k,p(:),1,n*k,n*k);
B = P*D*P'
%%
% Compute the SVD of each set of blocks
u = cell(3,1);
v = cell(3,1);
s = cell(3,1);
for ki=1:3
    [u{ki} s{ki} v{ki}] = svd(B((1:n) + (ki-1)*n,(1:n) + (ki-1)*n));
end
Uf = blkdiag(u{:});
Vf = blkdiag(v{:});
Sf = blkdiag(s{:});
%%
% Transform back to our form
U = bigF*P'*Uf*P*bigF';
S = bigF*P'*Sf*P*bigF';
V = bigF*P'*Vf*P*bigF';

%%
% ARG!  I know what it is... we store EVERYTHING backwards, so we are
% doing the SVD's on the wrong set of matrices ... I guess that is what
% I get for not documenting the data structure more clearly.


%% Final tests
A = cazeros(4,3,5);
A(1,1) = 1;
A(1,2) = 2;
A(2,2) = 3;
A(2,3) = 4;
A(3,3) = 5;
[U,S,V] = svd(A);
A - U*S*V'