%% Cirulant geometry
% In this experiment, we try and interpret circulant vectors to begin
% developing some geometry for them.
% For the sake of argument, we only consider positive circulants --
% circulant matrices with elements strictly greater than 0.

%% Setup
% add any paths or load any matlab packages here

darkgreen = [0 0.5 0.25];

%% Pick elements
k = 8;
n = 1;
X = randi([0,1],k,n);
Y = randi([0,1],k,n);
C = camat(reshape(X,k,n,1));
D = camat(reshape(Y,k,n,1));

%% Powers
figure(1); clf; hold on; 
h=plotcirc(C,'b'); 
E = cascalar(1,k)*(C*C);
h=plotcirc(E,'r');  set(h,'LineWidth',2);

%% Multiplication
figure(1); clf; 
h=plotcirc(C,'b'); hold on; set(h,'LineWidth',2);
h=plotcirc(D); set(h,'Color',darkgreen);
E = cascalar(1/k,k)*(C*D);
plotcirc(E,'r');

%% Division
figure(1); clf; hold on; plotcirc(C,'b'); h=plotcirc(D); set(h,'Color',darkgreen);
E = C./D;
plotcirc(E,'r');


%% Conjugation
figure(1); clf; hold on; plotcirc(C,'b');
E = conj(C);
plotcirc(E,'r');


