%% Comparison with Braman's eigenvalues/vectors
% We have the same eigenvalues/vectors as Braman's algorithm -- possibly up
% to a permutation.

n = 2;
k = 3;

% Construct the matrix
A = cazeros(n,n,k);
A(1,1) = cascalar([2 3 1]);
A(1,2) = cascalar([8 -2 0]);
A(2,1) = cascalar([-1 0 1]);
A(2,2) = cascalar([3 1 1]);

%% Contruct the FFT components
smallF = fft(eye(k))./sqrt(k);
F = kron(eye(n),smallF);
p = reshape(1:n*k,k,n)';
P = sparse(1:n*k,p(:),1,n*k,n*k);

%% Generate our eigenvalues
% First, we run "fft"
C = circ(A);
Ahat = P*F*circ(A)*F'*P'

%% Now we compute eigenvalues/vectors of each block.
% Matlab's natural sorting gives us the "right" order of everything, I
% think.
v = cell(k,1);
d = cell(k,1);
for ki=1:k
    [v{ki} d{ki}] = eig(Ahat((1:n) + (ki-1)*n,(1:n) + (ki-1)*n));
end
Vf = blkdiag(v{:});
Df = blkdiag(d{:});
CV = F'*P'*Vf*P*F
CD = F'*P'*Df*P*F
%% 
% Convert back into camats
V = uncirc(CV,k);
D = uncirc(CD,k);

mag(norm(A*V-V*D))
%%
% Note that D is indeed diagonal. 
D
%%
% In this case, V is not orthogonal because the matrices aren't symmetric.
mag(V'*V - caeye(n,n,k));
%%
% To compare eigenvalues to Braman's approach, save our matrix
Dus = D;

%% From Braman's perspective
A = zeros(2,2,3);
A(1,1,:) = [2 3 1];
A(1,2,:) = [8 -2 0];
A(2,1,:) = [-1 0 1];
A(2,2,:) = [3 1 1];
%%
B = bcirc(unfold(A),k);

%%
% Now diagonalize with the FFT
smallF = fft(eye(k))./sqrt(k);
F = kron(smallF,eye(n));
D = F*B*F'

%%
% And compute eigenvalues/vectors of the blocks
v = cell(3,1);
d = cell(3,1);
for ki=1:3
    [v{ki} d{ki}] = eig(Ahat((1:n) + (ki-1)*n,(1:n) + (ki-1)*n));
end
Vf = blkdiag(v{:});
Df = blkdiag(d{:});
CV = F'*Vf*F
CD = F'*Df*F
%%
% I don't have "fold" routines done, but notice that the
% eigenvalues are the same
Dus % these were our computed eigenvalues