function [Vfull,Dfull,Pfull] = analyze_eigenvalues_vectors_ordering(A)
% V matrix of eigenvectors
% A*V = V*D
% P = pattern for each eigenvalue in fourier space.

n = size(A,1);
k = size(A,3);
[V,D] = eig(A);
Dhat = fft(data(diag(D)));
Vhat = fft(data(V));


% compute all eigenvalues and vectors
Pset = perms(1:n);
bins = length(Pset)*ones(1,k);

for i=1:prod(bins)
    cur = cell(jpick,1);
    [cur{:}] = ind2sub(bins,i);
    cur = cell2mat(cur);
    for j=1:k
        % = sparse(1:n,perms(cur(j)),1,n,n);
        p = perms(cur(j));
        Vhat(j,:,:) = Vhat(j,p,:);
        Dhat(j,:) = Dhat(j,p);
    end
end

% compute all the eigenvalues and vectors
jpick = k;
bins = n*ones(1,jpick);
Dfull = cazeros(n^k,n^k,k);
Vfull = cazeros(n,n^k,k);
Pfull = cazeros(n,n^k,k);
for i=1:prod(bins)
    cur = cell(jpick,1);
    [cur{:}] = ind2sub(bins,i);
    cur = cell2mat(cur);
    Lvis = zeros(n,jpick);
    for j=1:jpick % use the last position 
        lhat(j) = Dhat(j,cur(j));
        Lvis(cur(j),j)=1;
    end
    ltest = cascalar(ifft(lhat));
    Pfull(:,i) = camat(Lvis').';
    Dfull(i,i) = ltest;
    Vfull(:,i) = V*camat(ifft(Lvis')).';
end
