function [x,lambda,hist,histlam] = cpowermtd(A,x,varargin)
% CPOWERMTD Power method in the circulant algebra

% David F. Gleich, Copyright 2009
% University of British Columbia

% History
% -------
% :2009-12-08: Initial coding

if ~exist('x','var'), x=[]; end
optionsu = struct(varargin{:});
options.maxiter = 1000;
options.tol = sqrt(eps);
options.verbose = 1;
for fi = fieldnames(options)'
    if isfield(optionsu,fi{1}), options.(fi{1}) = optionsu.(fi{1}); end 
end
maxiter = options.maxiter;
tol = options.tol;
verbose = options.verbose;


k = size(A,3);
[m,n] = size(A);
if m~=n,error('MATLAB:argchk:squareMatrixRequired','Matrix is not square');end
if isempty(x)
    x = carandn(n,1,k);
end

dt = tic;
hist=zeros(maxiter,1);
if (nargout>3)
    histlam = cazeros(maxiter,1,k);
end
for iter=1:maxiter
    Ax = A*x;
    lambda = x'*Ax;
    x2 = (1./ norm(Ax))*Ax;
    % compare against a fixed vector
    
    delta = mag(norm(sign(x(1))*x-sign(x2(1))*x2));
    hist(iter) = delta;
    if nargout>3
        histlam(iter) = lambda;
    end
    x = x2;
    if delta<tol
        break
    end
    if verbose
        t = toc(dt);
        fprintf(' %4i (%6.1f s)  %8.1e  %8.1e\n', iter, t, mag(lambda), delta);
    end      
end
hist = hist(1:iter);
if (nargout>3)
    histlam = histlam(1:iter);
end
