function [V,T] = clanczos(A,v,k,varargin)
% CLANCZOS Run the Lanczos process for k steps.
%
% [V,T] = clanczos(A,v,k) returns the k+1 set of Lanczos vectors and in
% opposite order.  This call does store the Lanczos vectors internally.
%
% See also CARNOLDI, CGOLUBKUBD

% Copyright, David Gleich 2009
% University of British Columbia

% History
% 2009-11-26: Initial coding based on lanczos.m (old package)

l = size(A,3);
n = size(v,1);

v = v./norm(v);
ab = cazeros(k,2,l);
V = cazeros(n,k+1,l);
r = v;
v1 = v; v1(:) = 0; 
b1 = v1(1); % this is just a quick way of saying set it to zero :-).

ii=0;
start = 0;
while (ii < k + start)
    ii=ii+1;
    V(:,ii) = v;
    p = A*v;
    ab(ii,1) = v'*p;
    r = p - ab(ii,1)*v - b1*v1;
    ab(ii,2) = norm(r);
    b1 = ab(ii,2);
    v1 = v;
    v = r./b1;
end;

V(:,end) = v;

T = cazeros(k+start+1,k+start,l);


%bend = [0; b(1:end-1)];
%T = spdiags([b a bend], [-1 0 1], k+1+start,k+start);