function [U,B,V] = cgolubkubd(A,v,k,varargin)
% CGOLUBKUBD Run the Golub-Kahan upper-bidiagonalization process for k steps.
%
% [U,B,V] = cgolubkubd(A,v,k) returns the Lanczos vectors as well.  The
% result satisfies A*V(:,1:k) = U*B(1:k,1:k).
%
% See also CLANCZOS, CARNOLDI, LANCZOSLB


% Copyright, David Gleich 2009
% University of British Columbia

% History
% 2009-11-26: Initial coding based on lanczosub.m (old package)


% run the startup
[m,n] = size(A);
l = size(A,3);
v = v./norm(v);
p = v;
beta_k = 1;
cur_k = 0;
u = 0;

alpha = cazeros(k,1,l);
beta = cazeros(k,1,l);
V = cazeros(n,k+1,l);
U = cazeros(m,k,l);

start = 0;

    
while (cur_k < k+start)
    cur_k = cur_k+1;

    V(:,cur_k) = v;
    r = A*v - beta_k*u;
    alpha_k = norm(r);
    u = r/alpha_k;

    U(:,cur_k) = u;

    p = (u'*A)' - alpha_k*v;
    beta_k = norm(p);

    alpha(cur_k) = alpha_k;
    beta(cur_k) = beta_k;
    v = p/beta_k;
end

%B = spdiags([alpha beta], 0:1, k+start,k+1+start);
B = cazeros(k+start,k+1+start,l);
for i=1:k+start
    B(i,i) = alpha(i);
    B(i,i+1) = beta(i);
end
V(:,end) = v;

