function [V,H] = carnoldi(A,v1,k)
% CARNOLDI Compute an arnoldi factorization for camat's.
%
% [V,H] = carnoldi(A,v,k) run k steps starting from a vector v.
%
% Example:
%   A = carandn(5,5,3);
%   [V,H] = carnoldi(A,carandn(5,1,3),2)
%   A*V(:,1:2) - V*H

v = v1./norm(v1);
V = cazeros(size(v1,1),k+1,size(A,3));
V(:,1) = v;
H = cazeros(k+1,k,size(A,3));
for j=1:k
   z = A*V(:,j);
   for i=1:j
       H(i,j) = V(:,i)'*z;
       z = z - H(i,j)*V(:,i);
   end
   H(j+1,j) = norm(z);
   V(:,j+1) = (1./H(j+1,j))*z;
end


    
