function C = carandn(m,n,k)
% CARANDN Generate a random circulant matrix
% 
% C = carandn(m,n,k) % random m-by-n k-circulant matrix
% C = carandn(m,k) % random m-by-m k-circulant matrix
% C = carandn(k) % random 1-by-1 k-circulant matrix


% David F. Gleich, Copyright 2009
% University of British Columbia

% History
% -------
% :2009-12-08: Initial coding

if nargin==1
    k = m;
    C = camat(randn(k,1,1));
elseif nargin==2
    k = n;
    C = camat(randn(k,m,m));
else
    C = camat(randn(k,n,m));
end
    