function C = carandi(range,m,n,k)
% CARANDI Generate a random integer circulant matrix
% 
% C = carandi(range,m,n,k) % random m-by-n k-circulant matrix
% C = carandi(range,m,k) % random m-by-m k-circulant matrix
% C = carandi(range,k) % random 1-by-1 k-circulant matrix
%
% range is either imax for 1:imax or [imin imax] for imin:imax
%
% Example:
%  carndi(10,3,2) %  entries in 1:10, matrix size 3-by-3 over K_2
%  carndi([-5,5],4,3,7) %  entries in -5:5, matrix size 4-by-3 over K_7

% David F. Gleich
% 2010-04-24

% History
% -------
% :2009-04-24: Initial coding

if nargin==2
    k = m;
    C = camat(randi(range,k,1,1));
elseif nargin==3
    k = n;
    C = camat(randi(range,k,m,m));
else
    C = camat(randi(range,k,n,m));
end
    