function C = carand(m,n,k)
% CARAND Generate a random circulant matrix
% 
% C = carand(m,n,k) % random m-by-n k-circulant matrix
% C = carand(m,k) % random m-by-m k-circulant matrix
% C = carand(k) % random 1-by-1 k-circulant matrix


% David F. Gleich, Copyright 2009
% University of British Columbia

% History
% -------
% :2009-12-08: Initial coding

if nargin==1
    k = m;
    C = camat(rand(k,1,1));
elseif nargin==2
    k = n;
    C = camat(rand(k,m,m));
else
    C = camat(rand(k,n,m));
end
    