function C = vertcat(varargin)
% VERTCAT Handle vertical catenation for circulant matrices
%
% C = vertcat(A1,...,Ak)
% All the A1,...,Ak must have the same vertical dimension.

% David F. Gleich
% 2010-04-23

% check dimensions
m = size(varargin{1},1);
n = size(varargin{1},2);
k = size(varargin{1},3);
N = length(varargin);

for i=2:N
    if size(varargin{i},2)~=n,
        error('MATLAB:catenate:dimensionMismatch',...
            'CAT arguments dimensions are not consistent.');
    end
    if size(varargin{i},3)~=k,
        error('camat:catenate:dimensionMismatch',...
            'CAT circulant argument dimensions are not consistent.');
    end
    m = m + size(varargin{i},1);
end

C = zeros(k,n,m);
r = 1; % current column
for i=1:N
    cur_m = size(varargin{i},1);
    C(:,:,r:r+cur_m-1,:) = varargin{i}.data;
    r = r+cur_m;
end
C = camat(C);
    
