function Z=times(X,Y)

% make sure the circulant dimensions work
if size(X,3)~=size(Y,3)
    error('Inner circulant dimension must agree (%i != %i)', ...
        size(X,3), size(Y,3));
end
% make sure the matrix dimensions work
if isscalar(X) || isscalar(Y)
    % dimensions always work.
    Xf = X.fft;
    Yf = Y.fft;
    Zf = repprod(Xf,Yf);
    Z = camatfft(ifft(Zf),Zf);
else
    
end
    