function [U,S,V] = svd(A)
% SVD Compute the SVD of a circulant matrix
%
% [U,S,V] = svd(A)
% s = svd(A)
%

% David F. Gleich
% 2010-04-22

[m,n] = size(A);
k = size(A,3);
F = fft(A.data);
if nargout>1
    U = zeros(k,m,m);
    S = zeros(k,min(m,n));
    V = zeros(k,n,n);
    for i=1:k
        [u,s,v] = svd(squeeze(F(i,:,:)));
        U(i,:,:) = u;
        S(i,:) = diag(s);
        V(i,:,:) = v;
    end
    U = ifft(U);
    S = ifft(S);
    V = ifft(V);
    U = camat(U);
    S = diag(camat(S));
    V = camat(V);
else
    S = zeros(k,min(m,n));
    for i=1:k
        S(i,:) = svd(squeeze(F(i,:,:)));
    end
    S = ifft(S);
    S = camat(S)';
    U = S;
end
