function [U,S,V] = svd(A)
% SVD Compute the SVD of a circulant matrix
%
% [U,S,V] = svd(A)
% s = svd(A)
%

% David F. Gleich
% 2010-04-22

[m,n] = size(A);
k = size(A,3);
F = fft(A.data);
if nargout>1
    U = zeros(k,m,m);
    S = zeros(k,n,m);
    V = zeros(k,n,n);
    for i=1:k
        % we transpose the data here.  Everything is just 
        % stored funny
        % rather than manipulating data, see the note above
        [u,s,v] = svd(squeeze(F(i,:,:)).');
        U(i,:,:) = u.';
        S(i,:,:) = s.';
        V(i,:,:) = v.';
    end
    % no reversal of the factors here as we've already done it
    U = camatfft(ifft(U),U);
    S = camatfft(ifft(S),S);
    V = camatfft(ifft(V),V);
else
    S = zeros(k,min(m,n));
    for i=1:k
        S(i,:) = svd(squeeze(F(i,:,:)));
    end
    S = camatfft(ifft(S),S)';
    U = S;
end
