function sref = subsref(obj,s)
% TODO Fix tabs
% obj(i) is equivalent to obj.Data(i)

% 2009-11-05: Fixed real element indexing

switch s(1).type
    % Use the built-in subsref for dot notation
    case '.'
        sref = builtin('subsref',obj,s);
    case '()'
        if length(s.subs) == 1
            s.subs{2} = s.subs{1};
            s.subs{1} = ':';
            d = builtin('subsref',obj.data,s);
            % this returns numel by k
            sref = camat(reshape(d,size(d,1),size(d,2),1));
        elseif length(s.subs)==2
            s.subs{3} = s.subs{1};
            s.subs{1} = ':';
            sref = camat(builtin('subsref',obj.data,s));
        elseif length(s.subs)==3
            ta = s.subs{1};
            s.subs{1} = s.subs{3};
            s.subs{3} = ta;
            sref = builtin('subsref',obj.data,s);
        end
        % No support for indexing using '{}'
    case '{}'
        error('camat:subsref',...
            'Not a supported subscripted reference')
end
