function obj = subsasgn(obj,s,val)

% 2009-11-05: Fixed real element indexing

if isempty(s) && isa(val,'camat')
  obj = camat(val.data);
end
switch s(1).type
% Use the built-in subsasagn for dot notation
  case '.'
     obj = builtin('subsasgn',obj,s,val);
  case '()'
     if length(s)<3
         if isfloat(val)
             if length(s.subs) == 1
                 s.subs{2} = s.subs{1};
                 s.subs{1} = ':';
                 d = builtin('subsasgn',obj.data,s,0);
                 s.subs{1} = 1;
                 d = builtin('subsasgn',d,s,val);
                 obj = camat(d);
             elseif length(s.subs) == 2
                 s.subs{3} = s.subs{1};
                 s.subs{1} = ':';
                 d = builtin('subsasgn',obj.data,s,0);
                 s.subs{1} = 1;
                 d = builtin('subsasgn',d,s,val);
                 obj = camat(d);
             else 
                 tmp = s.subs{1};
                 s.subs{1} = s.subs{3};
                 s.subs{3} = tmp;
                 d = builtin('subsasgn',obj.data,s,val);
                 obj = camat(d);
             end
         elseif isa(val,'camat');
             if length(s.subs) == 1
                 s.subs{2} = s.subs{1};
                 s.subs{1} = ':';
                 d = builtin('subsasgn',obj.data,s,val.data);
                 obj = camat(d);
             else
                 s.subs{3} = s.subs{1};
                 s.subs{1} = ':';
                 d = builtin('subsasgn',obj.data,s,val.data);
                 obj = camat(d);
             end
         end
     end
  % No support for indexing using '{}'
  case '{}'
     error('MYDataClass:subsasgn',...
        'Not a supported subscripted assignment')
end     
