function [D1,D2]=size(X,dim)
% SIZE Return the size of the matrix of circulant elements.
% D = size(X) for an M-by-N matrix of length K circulant elements, this
% returns D = [M,N], the size of the matrix.  
% [M,N] = size(X) returns the number of rows and columns as separate
% variables.
% M = size(X,dim) returns the length of a dimension.  
% K = size(X,3) returns the length of the circulant elements themselves.

% Copyright, David F. Gleich 2009
% University of British Columbia

% History
% :2009-11-25: Initial coding
% :2009-12-05: Fixed dimension return

% data is stored with reverse dimensions
[k,n,m]=size(X.data);
D1 = [m,n];
if nargin==2 && nargout<2
    if dim == 3,     D1 = k;
    elseif dim == 2, D1 = n;
    elseif dim == 1, D1 = m;
    else error('camat:invalidArgument','Dimension argument must be 1, 2, or 3');
    end
elseif nargin==1 && nargout==2
    D1 = m;
    D2 = n;
elseif nargout>1
    error('Unknown command option');
end
    
    
    


