function sX=sign(X)
% SIGN Compute the sign of the circulant elements
%   For real scalars, sign(x) is a function that produces a scalar
%   such that sign(x)*x = |x|*e1.  Thus, it indicates the direction to
%   rotate x so that it points in the same direction as the identity
%   element.
% 
%   For circulant vectors, it has the same function.
%   sign(x) is a unitary matrix such that sign(x)*x = |x|*e1
%   this means that it will preserve the 2 norm of the vector.  
%   In other words, this is a Householder transformation!

% 2009-12-08: Initial coding based on house.m from the Mathworks

n = size(X,3);
k = 0; % k is a variable used in the house.m function

sX = X.data;

for i=1:numel(X)
    x = sX(:,i);
    v = x;
    nrmx2n = norm(x(2:n));
    nrmx = norm([x(1) nrmx2n]);

    % stop if it's the 0 vectors
    if nrmx == 0, sX(:,i) = zeros(n,1); continue; end

    if x(1)==0
        mysign=1;
    else
        mysign=sign(x(1));
    end
    s = nrmx * mysign;
    if s < 0, k = 0; else k = 1; end

    if k == 0
       s = -s;
       v(1) = v(1) - s;
       beta = -1/(s'*v(1));                       % NB the conjugate.
    else
       v(1) = -nrmx2n^2 / (x(1)+s)';     % NB the conjugate.
       if v(1) == 0 % Special case where V = 0: need H = I.
          beta = 1;
       else
           beta = -1/(s'*v(1));                       % NB the conjugate.
       end
    end
    
    sX(:,i) = -beta*v(1)*v;
    sX(1,i) = 1+sX(1,i);
    sX(2:end,i) = sX(end:-1:2,i); % apply the tranpose
end
sX = camat(sX);

