function C=rdivide(A,B)
if isfloat(A) && isscalar(A)
    C = A./B.fft;
    C = camatfft(ifft(C),C);
elseif isfloat(B) && isscalar(B)
    C = camat(A.data./B);
elseif isa(A,'camat') && isa(B,'camat')
    if isscalar(A) || isscalar(B)
        C = repdiv(A.fft,B.fft);
        C = camatfft(ifft(C),C);
    else
        [ma,na] = size(A);
        [mb,nb] = size(B);
        ka = size(A,3);
        kb = size(B,3);
        if ka ~= kb
            error('Inner circulant dimension must agree');
        end
        if ma==mb && na==nb
            C = A.fft./B.fft;
            C = camatfft(ifft(C),C);
        else
            error('Matrix dimensions must agree');
        end
    end
else
    error('camat objects can only be combined with themselves or scalar doubles');
end