function [Q,R] = qr(A,varargin)
% QR Compute the QR of a circulant matrix
%
% [Q,R] = qr(A)
% R = qr(A)
%

% David F. Gleich
% 2010-04-23

full = 1;
if nargin>1
    full = varargin{1};
    if full ~= 0
        error('camat:qr:unknownOptionForEconomySize',...
          'Use qr(A,0) for the economy size decomposition');
    end
end

[m,n] = size(A);
k = size(A,3);
F = fft(A.data);
if nargout>1
    if full
        Q = zeros(k,m,m);
        R = zeros(k,n,m);
    else
        Q = zeros(k,n,m);
        R = zeros(k,n,n);
    end
    
    for i=1:k
        if full
            [q,r] = qr(squeeze(F(i,:,:)).');
        else
            [q,r] = qr(squeeze(F(i,:,:)).',0);
        end
        Q(i,:,:) = q.';
        R(i,:,:) = r.';
    end
    Q = camat(ifft(Q),Q);
    R = camat(ifft(R),R);
else
    R = zeros(k,n,m);
    for i=1:k
        r = qr(squeeze(F(i,:,:)).');
        r = triu(r);
        R(i,:,:) = r.';
    end
    Q = camat(ifft(R),R);
end
    
