function test_camat
msgid = 'camat:testFailed';
kberror=1;

try
    A = camat();
catch e
    error(msgid,['could not create empty camat ' ...
        '(Check that @camat is in a directory on the path!']);
end

a = [5 6 8 9];
b = [1 2];
c = repprod(a,b);
d = [5 12 8 18];
if ~isequal(c,d)
    if kberror, keyboard; end
    error(msgid,['repprod integer test failed']);
end

for i=1:20
    a = randn(1,30)+1i*randn(1,30);
    b = randn(6,1)+1i*randn(6,1);
    c = repprod(a,b);
    d = test_repprod(a,b);
    if norm(c-d)>eps(1)
        if kberror, keyboard; end
        error(msgid,['repprod test failed']);
    end
end


function z=test_repprod(x,y)

% swap so that x is always larger
if numel(y)>numel(x)
    t = x; x = y; y = t;
end
z = x;
k = numel(y);
j = 1;
for i=1:numel(x)
    z(i) = x(i)*y(j);
    j = j+1;
    if j>k, j=1; end
end