function x = norm(X,p)
% NORM Compute a norm of a circulant matrix or vector
% x = norm(X) returns the 2 norm of a vector X, or the Frobenius norm 
% of a matrix X.
% x = norm(X,p) returns the p-norm of a vector, of the Frobenius p-norm
% of a matrix X.

if nargin<2, p=2; end

if p==2
    Xf = abs(X.fft).^2;
    x = sum(sum(Xf,2),3);
    x = sqrt(x);
elseif p==1
    Xf = abs(X.fft);
    x = sum(sum(Xf,2),3);
elseif p==Inf
    Xf = abs(X.fft);
    x = max(max(Xf,[],2),[],3);
else
    Xf = abs(X.fft).^p;
    x = sum(sum(Xf,2),3);
    x = x.^(1/p);
end
x = reshape(x,size(X,3),1,1);

x = camatfft(ifft(x),x);
    
