function Z=mtimes(X,Y)

% make sure the circulant dimensions work
if size(X,3)~=size(Y,3)
    error('Inner circulant dimension must agree (%i != %i)', ...
        size(X,3), size(Y,3));
end
% make sure the matrix dimensions work
if isscalar(X) || isscalar(Y)
    % dimensions always work.
    Xf = X.fft;
    Yf = Y.fft;
    Zf = repprod(Xf,Yf);
    Z = camatfft(ifft(Zf),Zf);
else
    % determine what type of matrix product we have...
    [m,n] = size(X);
    [n2,l] = size(Y);
    if n ~= n2 
        error('Inner matrix dimensions must agree (%i != %i).', n, n2); 
    end
    Xf = X.fft;
    Yf = Y.fft;
    Zf = zeros(size(X,3),l,m);
    for j=1:size(X,3)
        % These are reversed here because we store everything
        % tranposed
        Zf(j,:,:) = reshape(Yf(j,:,:),l,n)*reshape(Xf(j,:,:),n,m);
    end
    Z = camatfft(ifft(Zf),Zf);
end

