function X = mldivide(A,b)
% MLDIVIDE Solve a linear system in the circulant algebra
%


% make sure the circulant dimensions work
if size(A,3)~=size(b,3)
    error('Inner circulant dimension must agree (%i != %i)', ...
        size(A,3), size(b,3));
end

Af = A.fft;
bf = b.fft;

k = size(A,3);
[m,n] = size(A);
[n2,l] = size(b);

Xf = zeros(k,l,n);
for j = 1:k
    Xf(j,:,:) = reshape(bf(j,:,:),l,n2)/reshape(Af(j,:,:),n,m);
end

X = camatfft(ifft(Xf),Xf);