function M=mag(X,k)
% MAG Compute the magnitude of the circulant elements
%   MAG(X) is the magnitude of each element in X.  It is a real matrix.  
%   MAG(X,k) uses the 

% 2009-12-08: Initial coding

if nargin==1, k=2; end
switch k
    case {1,Inf}
        M = reshape(sum(abs(X.data),1),size(X,2),size(X,1))';
    case 2
        F = abs(X.fft);
        M = max(F,[],1);
        M = reshape(M,size(X,2),size(X,1))';
    case 'fro'
        F = X.data.^2;
        M = sqrt(sum(F,1))./sqrt(size(X,3));
        M = reshape(M,size(X,2),size(X,1))';
    otherwise
        error('camat:mag','unknown magnitude type %i',type);
end