function C = horzcat(varargin)
% HORZCAT Handle horizontal catenation for circulant matrices
%
% C = horzcat(A1,...,Ak)
% All the A1,...,Ak must have the same horizontal dimension.

% David F. Gleich
% 2010-04-23

% check dimensions
m = size(varargin{1},1);
n = size(varargin{1},2);
k = size(varargin{1},3);
N = length(varargin);

for i=2:N
    if size(varargin{i},1)~=m,
        error('MATLAB:catenate:dimensionMismatch',...
            'CAT arguments dimensions are not consistent.');
    end
    if size(varargin{i},3)~=k,
        error('camat:catenate:dimensionMismatch',...
            'CAT circulant argument dimensions are not consistent.');
    end
    n = n + size(varargin{i},2);
end

C = zeros(k,n,m);
c = 1; % current column
for i=1:N
    cur_n = size(varargin{i},2);
    C(:,c:c+cur_n-1,:) = varargin{i}.data;
    c = c+cur_n;
end
C = camat(C);
    
