function [Q,H] = hess(A)
% HESS Compute the Hessenberg form of a circulant matrix
%
% [P,H] = hess(A)
% H = hess(A)
%

% David F. Gleich
% 2010-04-23

[m,n] = size(A);

if m~=n
    error('MATLAB:square','Matrix must be square.');
end

k = size(A,3);
F = A.fft;
if nargout>1
    
    Q = zeros(k,m,m);
    H = zeros(k,m,m);    
    
    for i=1:k
        [q,h] = hess(squeeze(F(i,:,:)).');
        Q(i,:,:) = q.';
        H(i,:,:) = h.';
    end
    Q = camatfft(ifft(Q),Q);
    H = camatfft(ifft(H),H);
else
    H = zeros(k,m,m);    
    
    for i=1:k
        h = hess(squeeze(F(i,:,:)).');
        H(i,:,:) = h.';
    end
    Q = camatfft(ifft(H),H);
end
    
