function [V,D] = EIG(A)
% SVD Compute the SVD of a circulant matrix
%
% [V,D] = eig(A)
% D = eig(A)
%

% David F. Gleich
% 2010-04-23

[m,n] = size(A);
k = size(A,3);
if any(imag(A.data(:)))
    error('camat:eig','currently, the code is specialized for real-valued circulants');
end
F = A.fft;
if nargout>1
    D = zeros(k,n,m);
    V = zeros(k,n,n);
    [v,d] = sortedeig(squeeze(F(1,:,:)).');
    D(1,:,:) = d.';
    V(1,:,:) = v.';
    for i=2:floor(k/2)+1
        % we transpose the data here.  Everything is just 
        % stored funny
        % rather than manipulating data, see the note above
        [v,d] = sortedeig(squeeze(F(i,:,:)).');
        D(i,:,:) = d;
        V(i,:,:) = v.';
        D(k-i+2,:,:) = conj(d);
        V(k-i+2,:,:) = conj(v).';
    end
    % no reversal of the factors here as we've already done it
    D = camatfft(ifft(D),D);
    V = camatfft(ifft(V),V);
else
    D = zeros(k,min(m,n));
    D(1,:) = sortedeig(squeeze(F(1,:,:)).');
    for i=2:floor(k/2)+1
        % we transpose the data here.  Everything is just 
        % stored funny
        % rather than manipulating data, see the note above
        D(i,:) = sortedeig(squeeze(F(i,:,:)).');
        D(k-i+2,:) = conj(D(i,:));
    end
    % no reversal of the factors here as we've already done it
    V = camatfft(ifft(D),D)';

end
function [V,D]=sortedeig(A)
if nargout==1
    d = eig(A);
    [ignore p] = sort(-abs(d)); % sort in decending order
    V = d(p);
else
    [V,D] = eig(A);
    d = diag(D);
    [ignore p] = sort(-abs(d)); % sort in decending order
    V = V(:,p);
    D = D(p,p);
end

