function D=diag(A)
% DIAG Just like diag, but for circulant algebra matrices
% 
%   DIAG(A) returns the diagonal elements of A as a vector
%   DIAG(v) returns a matrix with diagonal elements from v.
%

% 2009-02-11: Initial coding

[m,n] = size(A);
k = size(A,3);
if m==1 || n==1
    n = max(m,n);
    data = A.data;
    outdata = zeros(k,n,n);
    
    % assign the diagonal
    for i=1:n
        outdata(:,i,i) = data(:,i);
    end
else
    data = A.data;
	% extract the diagonal
    n = min(m,n);
    outdata = zeros(k,n,1);
    for i=1:n
        outdata(:,i) = data(:,i,i);
    end
end

D = camat(outdata);