function Abar = conj(A)
% CONJ Compute the circulant conjugate
% For each scalar element, this changes the order of the circulant so that
% a = [a1 a2 ... ak] becomes [a1 ak ... a2].  In the circulant algebra
% this produces the transpose operation.

% 2009-12-03: Initial coding

X = A.data;
k = size(A,3);
X = X([1 k:-1:2],:,:);
Abar = camatfft(X,conj(A.fft));
