function C = circ(A)
% CIRC Compute the matrix-of-circulants form 
%
% C = circ(A) returns a m*k-by-n*k matrix for a m-by-n circulant
% matrix over length-k circulants.

% David F. Gleich
% 2010-04-23

[m,n] = size(A);
k = size(A,3);
D = A.data;
C = cell(m,n);
for j=1:n
    for i=1:m
        v = squeeze(A.data(:,j,i));
        C{i,j} = gallery('circul',[v(1); v(end:-1:2)]);
    end
end
C = cell2mat(C);
  