function absX=abs(X)
% ABS Compute the absolute value of the circulant elements
%   ABS(X) is the absolute value of the elements in X, which 
%   corresponds to transforming each element of X to the nearest circulant
%   matrix with positive eigenvalues.

% 2009-12-03: Initial coding

Xf = abs(X.fft);
absX = camatfft(ifft(Xf),Xf);