/* Information for _3COM(tm) network interface cards 			*/
/* 	- currently only _3C905CB or better (full bus master)		*/

#define _3COM_VENDOR_ID			0x10b7
#define _3COM_3C905C_DEVICE_ID		0x9200

/* PCI Configuration Registers */

#define _3C905C_PCI_COMMAND 		0x04
#define _3C905C_PCI_IOBASE		0x10
#define _3C905C_PCI_MEMBASE		0x14
#define _3C905C_PCI_IRQ			0x3C

#define _3C905C_PCI_CMD_MASK 		0x07

#define _3C905C_RX_RING_SIZE 		32
#define _3C905C_TX_RING_SIZE 		16
#define _3C905C_RING_BOUNDARY 		16

#define _3C905C_CMD_TOTALRESET 		0x0000
#define _3C905C_CMD_SELECTWINDOW 	0x0800
#define _3C905C_CMD_STARTCOAX 		0x1000
#define _3C905C_CMD_RXDISABLE 		0x1800
#define _3C905C_CMD_RXENABLE 		0x2000
#define _3C905C_CMD_RXRESET 		0x2800
#define _3C905C_CMD_UPSTALL 		0x3000
#define _3C905C_CMD_UPUNSTALL 		0x3001
#define _3C905C_CMD_DOWNSTALL 		0x3002
#define _3C905C_CMD_DOWNUNSTALL 	0x3003
#define _3C905C_CMD_RXDISCARD 		0x4000
#define _3C905C_CMD_TXENABLE 		0x4800
#define _3C905C_CMD_TXDISABLE 		0x5000
#define _3C905C_CMD_TXRESET 		0x5800
#define _3C905C_CMD_FAKEINTR 		0x6000
#define _3C905C_CMD_ACKINTR 		0x6800
#define _3C905C_CMD_SETINTRENB 		0x7000
#define _3C905C_CMD_SETSTATUSENB 	0x7800
#define _3C905C_CMD_SETRXFILTER 	0x8000
#define _3C905C_CMD_SETRXTHRESHOLD 	0x8800
#define _3C905C_CMD_SETTXTHRESHOLD 	0x9000
#define _3C905C_CMD_SETTXSTART 		0x9800
#define _3C905C_CMD_STARTDMAUP 		0xa000
#define _3C905C_CMD_STARTDMADOWN 	0xa001
#define _3C905C_CMD_STATSENABLE 	0xa800
#define _3C905C_CMD_STATSDISABLE 	0xb000
#define _3C905C_CMD_STOPCOAX 		0xb800
#define _3C905C_CMD_SETFILTERBIT  	0xc800

#define _3C905C_STATUS_INTLATCH 	0x0001
#define _3C905C_STATUS_HOSTERROR	0x0002
#define _3C905C_STATUS_TXCOMPLETE	0x0004
#define _3C905C_STATUS_TXAVAILABLE	0x0008
#define _3C905C_STATUS_RXCOMPLETE 	0x0010
#define _3C905C_STATUS_RXEARLY		0x0020
#define _3C905C_STATUS_INTREQ		0x0040
#define _3C905C_STATUS_STATSFULL	0x0080
#define _3C905C_STATUS_DMADONE 		0x0100
#define _3C905C_STATUS_DOWNCOMPLETE 	0x0200
#define _3C905C_STATUS_UPCOMPLETE 	0x0400
#define _3C905C_STATUS_DMAINPROGRESS 	0x0800
#define _3C905C_STATUS_CMDINPROGRESS 	0x1000

#define _3C905C_WIN1_TXFIFO 		0x10
#define _3C905C_WIN1_RXFIFO 		0x10
#define _3C905C_WIN1_RXERRORS 		0x14
#define _3C905C_WIN1_RXSTATUS 		0x18
#define _3C905C_WIN1_TIMER 		0x1a
#define _3C905C_WIN1_TXSTATUS 		0x1b
#define _3C905C_WIN1_TXFREE 		0x1c

/* Window 3: MAC/config bits. */

#define _3C905C_WIN3_CONFIG		0
#define _3C905C_WIN3_MAXPKTSIZE 	4
#define _3C905C_WIN3_MACCTRL		6
#define _3C905C_WIN3_OPTIONS		8

/* Window 4: Xcvr/media bits. */

#define _3C905C_WIN4_FIFODIAG 		4
#define _3C905C_WIN4_NETDIAG 		6
#define _3C905C_WIN4_PHYSICALMGMT 	8
#define _3C905C_WIN4_MEDIA 		10

/* Bus Master Control Registers */
#define _3C905C_MSTCTRL_PKTSTATUS 	0x20
#define _3C905C_MSTCTRL_DOWNLISTPTR 	0x24
#define _3C905C_MSTCTRL_FRAGADDR 	0x28
#define _3C905C_MSTCTRL_FRAGLEN 	0x2c
#define _3C905C_MSTCTRL_TXFREETHRESHOLD 0x2f
#define _3C905C_MSTCTRL_UPPKTSTATUS 	0x30
#define _3C905C_MSTCTRL_UPLISTPTR 	0x38

#define _3C905C_RXFILTER_STATION 	0x01
#define _3C905C_RXFILTER_MULTICAST 	0x02
#define _3C905C_RXFILTER_BROADCAST 	0x04
#define _3C905C_RXFILTER_RXPROM 	0x08

#define _3C905C_FLAG_LASTFRAG 		0x80000000
#define _3C905C_FLAG_DOWNCOMPLETE 	0x00010000

#define _3C905C_DESC_RXDCOMPLETE 	0x00008000
#define _3C905C_DESC_RXDERROR 		0x00004000
#define _3C905C_DESC_TXINTRUPLOADED 	0x80000000

#define _3C905C_REG_STATUS		0x0e
#define _3C905C_REG_COMMAND		0x0e

#define _3C905C_IRQ_MASK 		( 				\
	_3C905C_STATUS_HOSTERROR 	| 				\
	_3C905C_STATUS_STATSFULL 	| 				\
	_3C905C_STATUS_TXCOMPLETE 	| 				\
	_3C905C_STATUS_INTLATCH 	| 				\
	_3C905C_STATUS_UPCOMPLETE 	| 				\
	_3C905C_STATUS_DOWNCOMPLETE 	)

#define _3C905C_WIN_SET(ethptr, win)				\
	outw((ethptr)->iobase +_3C905C_REG_COMMAND,		\
			_3C905C_CMD_SELECTWINDOW + (win))

/* Packet descriptor on a Rx/Tx ring */

struct _3c905C_desc {
	struct _3c905C_desc 	*next;
	uint32			status;
	uint32			buffer_addr;
	uint32			length;
};

#define _3C905C_PDSIZE		sizeof(struct	_3c905C_desc)
