/* ex6.c - additem */

#include <xinu.h>

sid32	mutex;			/* assume initialized with semcreate	*/
int32	shared[100];		/* an array shared by many processes	*/
int32	n = 0;			/* count of items in the array		*/

/*------------------------------------------------------------------------
 * additem  --  obtain exclusive access to array ary and add an item to it
 *------------------------------------------------------------------------
 */
void	additem(
	  int32		item	/* item to add to array ary		*/
	)
{
	wait(mutex);
	shared[n++] = item;
	signal(mutex);
}
