using System;
using System.Collections.Generic;
using System.Text;

using Microsoft.Modeling;

namespace StopwatchModel
{
    static class Model
    {
        public enum TimerMode { Reset, Running, Stopped }
       
        static bool displayTimer = false;
        static TimerMode timerMode = TimerMode.Reset;
        static bool timerFrozen = false;

        [Rule] 
        static void ModeButton()
        {
            displayTimer = !displayTimer;
        }

        [Rule] 
        static void StartStopButton()
        {
            Condition.IsTrue(displayTimer);
            if (timerMode == TimerMode.Running)
            {
                timerMode = TimerMode.Stopped;
                timerFrozen = false;
            }
            else
                timerMode = TimerMode.Running;
        }

        [Rule] 
        static void ResetLapButton()
        {
            Condition.IsTrue(displayTimer);
            Condition.IsFalse(timerMode == TimerMode.Reset);
            if (timerMode == TimerMode.Running)
                timerFrozen = !timerFrozen;
            else
                timerMode = TimerMode.Reset;
        }               

        [Rule] 
        static bool IsTimerReset()
        {
            return timerMode == TimerMode.Reset;
        }

        [Probe]
        public static string DisplayState()
        {
            return String.Format("{0}|{1}{2}",
                displayTimer ? "Timer" : "DateTime",
                timerMode,
                timerFrozen ? "|Frozen" : "");
        }

                             
    }
}
