using System;
using System.Collections.Generic;
using System.Text;

namespace Devices
{
   
    /// <summary>
    /// A mock implementation that doesn't conform to the model (testing should fail).
    /// </summary>
    public class Stopwatch
    {
        public enum TimerMode { Reset, Running, Stopped }

        static bool displayTimer = false;
        static TimerMode timerMode = TimerMode.Reset;
        static bool timerFrozen = false;

        public static void Initialize()
        {
            displayTimer = false;
            timerMode = TimerMode.Reset;
            timerFrozen = false;
            UpdateForm();
        }

        public static void ModeButton()
        {
            displayTimer = !displayTimer;
            
            //bug
            if (!displayTimer)
                timerMode = TimerMode.Reset;
            
            UpdateForm();
        }

        public static void StartStopButton()
        {
            if (timerMode == TimerMode.Running)
            {
                timerMode = TimerMode.Stopped;
                timerFrozen = false;
            }
            else
                timerMode = TimerMode.Running;
            UpdateForm();
        }

        public static void ResetLapButton()
        {
            if (timerMode == TimerMode.Running)
                timerFrozen = !timerFrozen;
            else
                timerMode = TimerMode.Reset;
        }


        public static bool IsTimerReset()
        {
            return timerMode == TimerMode.Reset;
        }



        #region Animation
        static StopwatchForm form;
        static System.Threading.Thread owner;

        static void UpdateForm()
        {
            if (form != null && owner != System.Threading.Thread.CurrentThread)
            {
                form.Close();
                form = null;
            }
            if (form == null)
            {
                form = new StopwatchForm();
                form.Show();
                form.BringToFront();
                form.Activate();
                System.Windows.Forms.Application.DoEvents();
                owner = System.Threading.Thread.CurrentThread;
            }
            string s;
            if (displayTimer)
            {
                s = timerMode.ToString();
                s += "\r\n";
                if (timerFrozen)
                    s += "frozen";
            }
            else
                s = "DateTime\r\n";
            form.SetDisplay(s);
        }
        #endregion

    }
}
