#include "gl_core_3_3.h"
/* This file was auto-generated by Galogen */
#include <assert.h>
#if defined(_WIN32)
void* GalogenGetProcAddress(const char *name) {
  static HMODULE opengl32module = NULL;
  static PROC(WINAPI *wgl_get_proc_address)(LPCSTR name) = NULL;
  if (!wgl_get_proc_address) {
    if (!opengl32module) {
      opengl32module = LoadLibraryA("opengl32.dll");
    }
    wgl_get_proc_address = (PROC(WINAPI*)(LPCSTR))GetProcAddress(opengl32module, "wglGetProcAddress");
    assert(wgl_get_proc_address);
  }
  void *ptr = (void *)wgl_get_proc_address(name);
  if(ptr == 0 || (ptr == (void*)1) || (ptr == (void*)2) || (ptr == (void*)3) ||
     (ptr == (void*)-1) ) {
    if (opengl32module == NULL) {
      opengl32module = LoadLibraryA("opengl32.dll");
      assert(opengl32module);
    }
    ptr = (void *)GetProcAddress(opengl32module, name);
  }
  return ptr;
}

#elif defined(__APPLE__)
#include <dlfcn.h>

static void* GalogenGetProcAddress (const char *name)
{
  static void* lib = NULL;
  if (NULL == lib)
    lib = dlopen(
      "/System/Library/Frameworks/OpenGL.framework/Versions/Current/OpenGL",
      RTLD_LAZY);
  return lib ? dlsym(lib, name) : NULL;
}
#elif defined(__ANDROID__)
#include <dlfcn.h>
#if GALOGEN_API_VER_MAJ == 3
#define GALOGEN_GLES_LIB "libGLESv3.so"
#elif GALOGEN_API_VER_MAJ == 2
#define GALOGEN_GLES_LIB "libGLESv2.so"
#else
#define GALOGEN_GLES_LIB "libGLESv1_CM.so"
#endif
static void* GalogenGetProcAddress(const char *name)
{
  static void* lib = NULL;
  if (NULL == lib) {
    lib = dlopen(GALOGEN_GLES_LIB, RTLD_LAZY);
    assert(lib);
  }
  return lib ? dlsym(lib, name) : NULL;
}

#else

#include <GL/glx.h>
#define GalogenGetProcAddress(name) (*glXGetProcAddressARB)((const GLubyte*)name)

#endif


static void  GL_APIENTRY _impl_glVertexAttribP4uiv (GLuint index, GLenum type, GLboolean normalized, const GLuint * value) {
  _glptr_glVertexAttribP4uiv = (PFN_glVertexAttribP4uiv)GalogenGetProcAddress("glVertexAttribP4uiv");
   _glptr_glVertexAttribP4uiv(index, type, normalized, value);
}
PFN_glVertexAttribP4uiv _glptr_glVertexAttribP4uiv = _impl_glVertexAttribP4uiv;

static void  GL_APIENTRY _impl_glVertexAttribP3uiv (GLuint index, GLenum type, GLboolean normalized, const GLuint * value) {
  _glptr_glVertexAttribP3uiv = (PFN_glVertexAttribP3uiv)GalogenGetProcAddress("glVertexAttribP3uiv");
   _glptr_glVertexAttribP3uiv(index, type, normalized, value);
}
PFN_glVertexAttribP3uiv _glptr_glVertexAttribP3uiv = _impl_glVertexAttribP3uiv;

static void  GL_APIENTRY _impl_glVertexAttribP2uiv (GLuint index, GLenum type, GLboolean normalized, const GLuint * value) {
  _glptr_glVertexAttribP2uiv = (PFN_glVertexAttribP2uiv)GalogenGetProcAddress("glVertexAttribP2uiv");
   _glptr_glVertexAttribP2uiv(index, type, normalized, value);
}
PFN_glVertexAttribP2uiv _glptr_glVertexAttribP2uiv = _impl_glVertexAttribP2uiv;

static void  GL_APIENTRY _impl_glVertexAttribP2ui (GLuint index, GLenum type, GLboolean normalized, GLuint value) {
  _glptr_glVertexAttribP2ui = (PFN_glVertexAttribP2ui)GalogenGetProcAddress("glVertexAttribP2ui");
   _glptr_glVertexAttribP2ui(index, type, normalized, value);
}
PFN_glVertexAttribP2ui _glptr_glVertexAttribP2ui = _impl_glVertexAttribP2ui;

static void  GL_APIENTRY _impl_glVertexAttribP1uiv (GLuint index, GLenum type, GLboolean normalized, const GLuint * value) {
  _glptr_glVertexAttribP1uiv = (PFN_glVertexAttribP1uiv)GalogenGetProcAddress("glVertexAttribP1uiv");
   _glptr_glVertexAttribP1uiv(index, type, normalized, value);
}
PFN_glVertexAttribP1uiv _glptr_glVertexAttribP1uiv = _impl_glVertexAttribP1uiv;

static void  GL_APIENTRY _impl_glGetQueryObjectui64v (GLuint id, GLenum pname, GLuint64 * params) {
  _glptr_glGetQueryObjectui64v = (PFN_glGetQueryObjectui64v)GalogenGetProcAddress("glGetQueryObjectui64v");
   _glptr_glGetQueryObjectui64v(id, pname, params);
}
PFN_glGetQueryObjectui64v _glptr_glGetQueryObjectui64v = _impl_glGetQueryObjectui64v;

static void  GL_APIENTRY _impl_glGetSamplerParameterfv (GLuint sampler, GLenum pname, GLfloat * params) {
  _glptr_glGetSamplerParameterfv = (PFN_glGetSamplerParameterfv)GalogenGetProcAddress("glGetSamplerParameterfv");
   _glptr_glGetSamplerParameterfv(sampler, pname, params);
}
PFN_glGetSamplerParameterfv _glptr_glGetSamplerParameterfv = _impl_glGetSamplerParameterfv;

static void  GL_APIENTRY _impl_glSamplerParameterIuiv (GLuint sampler, GLenum pname, const GLuint * param) {
  _glptr_glSamplerParameterIuiv = (PFN_glSamplerParameterIuiv)GalogenGetProcAddress("glSamplerParameterIuiv");
   _glptr_glSamplerParameterIuiv(sampler, pname, param);
}
PFN_glSamplerParameterIuiv _glptr_glSamplerParameterIuiv = _impl_glSamplerParameterIuiv;

static void  GL_APIENTRY _impl_glSamplerParameterfv (GLuint sampler, GLenum pname, const GLfloat * param) {
  _glptr_glSamplerParameterfv = (PFN_glSamplerParameterfv)GalogenGetProcAddress("glSamplerParameterfv");
   _glptr_glSamplerParameterfv(sampler, pname, param);
}
PFN_glSamplerParameterfv _glptr_glSamplerParameterfv = _impl_glSamplerParameterfv;

static void  GL_APIENTRY _impl_glSamplerParameteriv (GLuint sampler, GLenum pname, const GLint * param) {
  _glptr_glSamplerParameteriv = (PFN_glSamplerParameteriv)GalogenGetProcAddress("glSamplerParameteriv");
   _glptr_glSamplerParameteriv(sampler, pname, param);
}
PFN_glSamplerParameteriv _glptr_glSamplerParameteriv = _impl_glSamplerParameteriv;

static void  GL_APIENTRY _impl_glSamplerParameteri (GLuint sampler, GLenum pname, GLint param) {
  _glptr_glSamplerParameteri = (PFN_glSamplerParameteri)GalogenGetProcAddress("glSamplerParameteri");
   _glptr_glSamplerParameteri(sampler, pname, param);
}
PFN_glSamplerParameteri _glptr_glSamplerParameteri = _impl_glSamplerParameteri;

static void  GL_APIENTRY _impl_glBindSampler (GLuint unit, GLuint sampler) {
  _glptr_glBindSampler = (PFN_glBindSampler)GalogenGetProcAddress("glBindSampler");
   _glptr_glBindSampler(unit, sampler);
}
PFN_glBindSampler _glptr_glBindSampler = _impl_glBindSampler;

static void  GL_APIENTRY _impl_glSamplerParameterf (GLuint sampler, GLenum pname, GLfloat param) {
  _glptr_glSamplerParameterf = (PFN_glSamplerParameterf)GalogenGetProcAddress("glSamplerParameterf");
   _glptr_glSamplerParameterf(sampler, pname, param);
}
PFN_glSamplerParameterf _glptr_glSamplerParameterf = _impl_glSamplerParameterf;

static GLboolean GL_APIENTRY _impl_glIsSampler (GLuint sampler) {
  _glptr_glIsSampler = (PFN_glIsSampler)GalogenGetProcAddress("glIsSampler");
  return _glptr_glIsSampler(sampler);
}
PFN_glIsSampler _glptr_glIsSampler = _impl_glIsSampler;

static void  GL_APIENTRY _impl_glGenSamplers (GLsizei count, GLuint * samplers) {
  _glptr_glGenSamplers = (PFN_glGenSamplers)GalogenGetProcAddress("glGenSamplers");
   _glptr_glGenSamplers(count, samplers);
}
PFN_glGenSamplers _glptr_glGenSamplers = _impl_glGenSamplers;

static void  GL_APIENTRY _impl_glBindFragDataLocationIndexed (GLuint program, GLuint colorNumber, GLuint index, const GLchar * name) {
  _glptr_glBindFragDataLocationIndexed = (PFN_glBindFragDataLocationIndexed)GalogenGetProcAddress("glBindFragDataLocationIndexed");
   _glptr_glBindFragDataLocationIndexed(program, colorNumber, index, name);
}
PFN_glBindFragDataLocationIndexed _glptr_glBindFragDataLocationIndexed = _impl_glBindFragDataLocationIndexed;

static void  GL_APIENTRY _impl_glGetMultisamplefv (GLenum pname, GLuint index, GLfloat * val) {
  _glptr_glGetMultisamplefv = (PFN_glGetMultisamplefv)GalogenGetProcAddress("glGetMultisamplefv");
   _glptr_glGetMultisamplefv(pname, index, val);
}
PFN_glGetMultisamplefv _glptr_glGetMultisamplefv = _impl_glGetMultisamplefv;

static void  GL_APIENTRY _impl_glTexImage3DMultisample (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations) {
  _glptr_glTexImage3DMultisample = (PFN_glTexImage3DMultisample)GalogenGetProcAddress("glTexImage3DMultisample");
   _glptr_glTexImage3DMultisample(target, samples, internalformat, width, height, depth, fixedsamplelocations);
}
PFN_glTexImage3DMultisample _glptr_glTexImage3DMultisample = _impl_glTexImage3DMultisample;

static void  GL_APIENTRY _impl_glFramebufferTexture (GLenum target, GLenum attachment, GLuint texture, GLint level) {
  _glptr_glFramebufferTexture = (PFN_glFramebufferTexture)GalogenGetProcAddress("glFramebufferTexture");
   _glptr_glFramebufferTexture(target, attachment, texture, level);
}
PFN_glFramebufferTexture _glptr_glFramebufferTexture = _impl_glFramebufferTexture;

static void  GL_APIENTRY _impl_glGetBufferParameteri64v (GLenum target, GLenum pname, GLint64 * params) {
  _glptr_glGetBufferParameteri64v = (PFN_glGetBufferParameteri64v)GalogenGetProcAddress("glGetBufferParameteri64v");
   _glptr_glGetBufferParameteri64v(target, pname, params);
}
PFN_glGetBufferParameteri64v _glptr_glGetBufferParameteri64v = _impl_glGetBufferParameteri64v;

static void  GL_APIENTRY _impl_glGetInteger64i_v (GLenum target, GLuint index, GLint64 * data) {
  _glptr_glGetInteger64i_v = (PFN_glGetInteger64i_v)GalogenGetProcAddress("glGetInteger64i_v");
   _glptr_glGetInteger64i_v(target, index, data);
}
PFN_glGetInteger64i_v _glptr_glGetInteger64i_v = _impl_glGetInteger64i_v;

static void  GL_APIENTRY _impl_glWaitSync (GLsync sync, GLbitfield flags, GLuint64 timeout) {
  _glptr_glWaitSync = (PFN_glWaitSync)GalogenGetProcAddress("glWaitSync");
   _glptr_glWaitSync(sync, flags, timeout);
}
PFN_glWaitSync _glptr_glWaitSync = _impl_glWaitSync;

static GLboolean GL_APIENTRY _impl_glIsSync (GLsync sync) {
  _glptr_glIsSync = (PFN_glIsSync)GalogenGetProcAddress("glIsSync");
  return _glptr_glIsSync(sync);
}
PFN_glIsSync _glptr_glIsSync = _impl_glIsSync;

static GLsync GL_APIENTRY _impl_glFenceSync (GLenum condition, GLbitfield flags) {
  _glptr_glFenceSync = (PFN_glFenceSync)GalogenGetProcAddress("glFenceSync");
  return _glptr_glFenceSync(condition, flags);
}
PFN_glFenceSync _glptr_glFenceSync = _impl_glFenceSync;

static void  GL_APIENTRY _impl_glMultiDrawElementsBaseVertex (GLenum mode, const GLsizei * count, GLenum type, const void *const* indices, GLsizei drawcount, const GLint * basevertex) {
  _glptr_glMultiDrawElementsBaseVertex = (PFN_glMultiDrawElementsBaseVertex)GalogenGetProcAddress("glMultiDrawElementsBaseVertex");
   _glptr_glMultiDrawElementsBaseVertex(mode, count, type, indices, drawcount, basevertex);
}
PFN_glMultiDrawElementsBaseVertex _glptr_glMultiDrawElementsBaseVertex = _impl_glMultiDrawElementsBaseVertex;

static void  GL_APIENTRY _impl_glDrawElementsInstancedBaseVertex (GLenum mode, GLsizei count, GLenum type, const void * indices, GLsizei instancecount, GLint basevertex) {
  _glptr_glDrawElementsInstancedBaseVertex = (PFN_glDrawElementsInstancedBaseVertex)GalogenGetProcAddress("glDrawElementsInstancedBaseVertex");
   _glptr_glDrawElementsInstancedBaseVertex(mode, count, type, indices, instancecount, basevertex);
}
PFN_glDrawElementsInstancedBaseVertex _glptr_glDrawElementsInstancedBaseVertex = _impl_glDrawElementsInstancedBaseVertex;

static void  GL_APIENTRY _impl_glGetActiveUniformBlockName (GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei * length, GLchar * uniformBlockName) {
  _glptr_glGetActiveUniformBlockName = (PFN_glGetActiveUniformBlockName)GalogenGetProcAddress("glGetActiveUniformBlockName");
   _glptr_glGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, length, uniformBlockName);
}
PFN_glGetActiveUniformBlockName _glptr_glGetActiveUniformBlockName = _impl_glGetActiveUniformBlockName;

static GLuint GL_APIENTRY _impl_glGetUniformBlockIndex (GLuint program, const GLchar * uniformBlockName) {
  _glptr_glGetUniformBlockIndex = (PFN_glGetUniformBlockIndex)GalogenGetProcAddress("glGetUniformBlockIndex");
  return _glptr_glGetUniformBlockIndex(program, uniformBlockName);
}
PFN_glGetUniformBlockIndex _glptr_glGetUniformBlockIndex = _impl_glGetUniformBlockIndex;

static void  GL_APIENTRY _impl_glGetActiveUniformName (GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei * length, GLchar * uniformName) {
  _glptr_glGetActiveUniformName = (PFN_glGetActiveUniformName)GalogenGetProcAddress("glGetActiveUniformName");
   _glptr_glGetActiveUniformName(program, uniformIndex, bufSize, length, uniformName);
}
PFN_glGetActiveUniformName _glptr_glGetActiveUniformName = _impl_glGetActiveUniformName;

static void  GL_APIENTRY _impl_glGetUniformIndices (GLuint program, GLsizei uniformCount, const GLchar *const* uniformNames, GLuint * uniformIndices) {
  _glptr_glGetUniformIndices = (PFN_glGetUniformIndices)GalogenGetProcAddress("glGetUniformIndices");
   _glptr_glGetUniformIndices(program, uniformCount, uniformNames, uniformIndices);
}
PFN_glGetUniformIndices _glptr_glGetUniformIndices = _impl_glGetUniformIndices;

static void  GL_APIENTRY _impl_glTexBuffer (GLenum target, GLenum internalformat, GLuint buffer) {
  _glptr_glTexBuffer = (PFN_glTexBuffer)GalogenGetProcAddress("glTexBuffer");
   _glptr_glTexBuffer(target, internalformat, buffer);
}
PFN_glTexBuffer _glptr_glTexBuffer = _impl_glTexBuffer;

static GLboolean GL_APIENTRY _impl_glIsVertexArray (GLuint array) {
  _glptr_glIsVertexArray = (PFN_glIsVertexArray)GalogenGetProcAddress("glIsVertexArray");
  return _glptr_glIsVertexArray(array);
}
PFN_glIsVertexArray _glptr_glIsVertexArray = _impl_glIsVertexArray;

static void  GL_APIENTRY _impl_glBindVertexArray (GLuint array) {
  _glptr_glBindVertexArray = (PFN_glBindVertexArray)GalogenGetProcAddress("glBindVertexArray");
   _glptr_glBindVertexArray(array);
}
PFN_glBindVertexArray _glptr_glBindVertexArray = _impl_glBindVertexArray;

static void  GL_APIENTRY _impl_glFlushMappedBufferRange (GLenum target, GLintptr offset, GLsizeiptr length) {
  _glptr_glFlushMappedBufferRange = (PFN_glFlushMappedBufferRange)GalogenGetProcAddress("glFlushMappedBufferRange");
   _glptr_glFlushMappedBufferRange(target, offset, length);
}
PFN_glFlushMappedBufferRange _glptr_glFlushMappedBufferRange = _impl_glFlushMappedBufferRange;

static void * GL_APIENTRY _impl_glMapBufferRange (GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access) {
  _glptr_glMapBufferRange = (PFN_glMapBufferRange)GalogenGetProcAddress("glMapBufferRange");
  return _glptr_glMapBufferRange(target, offset, length, access);
}
PFN_glMapBufferRange _glptr_glMapBufferRange = _impl_glMapBufferRange;

static void  GL_APIENTRY _impl_glGetActiveUniformsiv (GLuint program, GLsizei uniformCount, const GLuint * uniformIndices, GLenum pname, GLint * params) {
  _glptr_glGetActiveUniformsiv = (PFN_glGetActiveUniformsiv)GalogenGetProcAddress("glGetActiveUniformsiv");
   _glptr_glGetActiveUniformsiv(program, uniformCount, uniformIndices, pname, params);
}
PFN_glGetActiveUniformsiv _glptr_glGetActiveUniformsiv = _impl_glGetActiveUniformsiv;

static void  GL_APIENTRY _impl_glFramebufferTextureLayer (GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer) {
  _glptr_glFramebufferTextureLayer = (PFN_glFramebufferTextureLayer)GalogenGetProcAddress("glFramebufferTextureLayer");
   _glptr_glFramebufferTextureLayer(target, attachment, texture, level, layer);
}
PFN_glFramebufferTextureLayer _glptr_glFramebufferTextureLayer = _impl_glFramebufferTextureLayer;

static void  GL_APIENTRY _impl_glGetFramebufferAttachmentParameteriv (GLenum target, GLenum attachment, GLenum pname, GLint * params) {
  _glptr_glGetFramebufferAttachmentParameteriv = (PFN_glGetFramebufferAttachmentParameteriv)GalogenGetProcAddress("glGetFramebufferAttachmentParameteriv");
   _glptr_glGetFramebufferAttachmentParameteriv(target, attachment, pname, params);
}
PFN_glGetFramebufferAttachmentParameteriv _glptr_glGetFramebufferAttachmentParameteriv = _impl_glGetFramebufferAttachmentParameteriv;

static void  GL_APIENTRY _impl_glFramebufferTexture3D (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset) {
  _glptr_glFramebufferTexture3D = (PFN_glFramebufferTexture3D)GalogenGetProcAddress("glFramebufferTexture3D");
   _glptr_glFramebufferTexture3D(target, attachment, textarget, texture, level, zoffset);
}
PFN_glFramebufferTexture3D _glptr_glFramebufferTexture3D = _impl_glFramebufferTexture3D;

static void  GL_APIENTRY _impl_glFramebufferTexture1D (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) {
  _glptr_glFramebufferTexture1D = (PFN_glFramebufferTexture1D)GalogenGetProcAddress("glFramebufferTexture1D");
   _glptr_glFramebufferTexture1D(target, attachment, textarget, texture, level);
}
PFN_glFramebufferTexture1D _glptr_glFramebufferTexture1D = _impl_glFramebufferTexture1D;

static void  GL_APIENTRY _impl_glGenFramebuffers (GLsizei n, GLuint * framebuffers) {
  _glptr_glGenFramebuffers = (PFN_glGenFramebuffers)GalogenGetProcAddress("glGenFramebuffers");
   _glptr_glGenFramebuffers(n, framebuffers);
}
PFN_glGenFramebuffers _glptr_glGenFramebuffers = _impl_glGenFramebuffers;

static void  GL_APIENTRY _impl_glBindFramebuffer (GLenum target, GLuint framebuffer) {
  _glptr_glBindFramebuffer = (PFN_glBindFramebuffer)GalogenGetProcAddress("glBindFramebuffer");
   _glptr_glBindFramebuffer(target, framebuffer);
}
PFN_glBindFramebuffer _glptr_glBindFramebuffer = _impl_glBindFramebuffer;

static void  GL_APIENTRY _impl_glGetQueryObjecti64v (GLuint id, GLenum pname, GLint64 * params) {
  _glptr_glGetQueryObjecti64v = (PFN_glGetQueryObjecti64v)GalogenGetProcAddress("glGetQueryObjecti64v");
   _glptr_glGetQueryObjecti64v(id, pname, params);
}
PFN_glGetQueryObjecti64v _glptr_glGetQueryObjecti64v = _impl_glGetQueryObjecti64v;

static void  GL_APIENTRY _impl_glGetInteger64v (GLenum pname, GLint64 * data) {
  _glptr_glGetInteger64v = (PFN_glGetInteger64v)GalogenGetProcAddress("glGetInteger64v");
   _glptr_glGetInteger64v(pname, data);
}
PFN_glGetInteger64v _glptr_glGetInteger64v = _impl_glGetInteger64v;

static GLboolean GL_APIENTRY _impl_glIsFramebuffer (GLuint framebuffer) {
  _glptr_glIsFramebuffer = (PFN_glIsFramebuffer)GalogenGetProcAddress("glIsFramebuffer");
  return _glptr_glIsFramebuffer(framebuffer);
}
PFN_glIsFramebuffer _glptr_glIsFramebuffer = _impl_glIsFramebuffer;

static void  GL_APIENTRY _impl_glGetRenderbufferParameteriv (GLenum target, GLenum pname, GLint * params) {
  _glptr_glGetRenderbufferParameteriv = (PFN_glGetRenderbufferParameteriv)GalogenGetProcAddress("glGetRenderbufferParameteriv");
   _glptr_glGetRenderbufferParameteriv(target, pname, params);
}
PFN_glGetRenderbufferParameteriv _glptr_glGetRenderbufferParameteriv = _impl_glGetRenderbufferParameteriv;

static void  GL_APIENTRY _impl_glBindRenderbuffer (GLenum target, GLuint renderbuffer) {
  _glptr_glBindRenderbuffer = (PFN_glBindRenderbuffer)GalogenGetProcAddress("glBindRenderbuffer");
   _glptr_glBindRenderbuffer(target, renderbuffer);
}
PFN_glBindRenderbuffer _glptr_glBindRenderbuffer = _impl_glBindRenderbuffer;

static GLboolean GL_APIENTRY _impl_glIsRenderbuffer (GLuint renderbuffer) {
  _glptr_glIsRenderbuffer = (PFN_glIsRenderbuffer)GalogenGetProcAddress("glIsRenderbuffer");
  return _glptr_glIsRenderbuffer(renderbuffer);
}
PFN_glIsRenderbuffer _glptr_glIsRenderbuffer = _impl_glIsRenderbuffer;

static const GLubyte * GL_APIENTRY _impl_glGetStringi (GLenum name, GLuint index) {
  _glptr_glGetStringi = (PFN_glGetStringi)GalogenGetProcAddress("glGetStringi");
  return _glptr_glGetStringi(name, index);
}
PFN_glGetStringi _glptr_glGetStringi = _impl_glGetStringi;

static void  GL_APIENTRY _impl_glClearBufferfi (GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil) {
  _glptr_glClearBufferfi = (PFN_glClearBufferfi)GalogenGetProcAddress("glClearBufferfi");
   _glptr_glClearBufferfi(buffer, drawbuffer, depth, stencil);
}
PFN_glClearBufferfi _glptr_glClearBufferfi = _impl_glClearBufferfi;

static void  GL_APIENTRY _impl_glClearBufferfv (GLenum buffer, GLint drawbuffer, const GLfloat * value) {
  _glptr_glClearBufferfv = (PFN_glClearBufferfv)GalogenGetProcAddress("glClearBufferfv");
   _glptr_glClearBufferfv(buffer, drawbuffer, value);
}
PFN_glClearBufferfv _glptr_glClearBufferfv = _impl_glClearBufferfv;

static void  GL_APIENTRY _impl_glGetTexParameterIiv (GLenum target, GLenum pname, GLint * params) {
  _glptr_glGetTexParameterIiv = (PFN_glGetTexParameterIiv)GalogenGetProcAddress("glGetTexParameterIiv");
   _glptr_glGetTexParameterIiv(target, pname, params);
}
PFN_glGetTexParameterIiv _glptr_glGetTexParameterIiv = _impl_glGetTexParameterIiv;

static void  GL_APIENTRY _impl_glGetSamplerParameterIuiv (GLuint sampler, GLenum pname, GLuint * params) {
  _glptr_glGetSamplerParameterIuiv = (PFN_glGetSamplerParameterIuiv)GalogenGetProcAddress("glGetSamplerParameterIuiv");
   _glptr_glGetSamplerParameterIuiv(sampler, pname, params);
}
PFN_glGetSamplerParameterIuiv _glptr_glGetSamplerParameterIuiv = _impl_glGetSamplerParameterIuiv;

static void  GL_APIENTRY _impl_glTexParameterIiv (GLenum target, GLenum pname, const GLint * params) {
  _glptr_glTexParameterIiv = (PFN_glTexParameterIiv)GalogenGetProcAddress("glTexParameterIiv");
   _glptr_glTexParameterIiv(target, pname, params);
}
PFN_glTexParameterIiv _glptr_glTexParameterIiv = _impl_glTexParameterIiv;

static void  GL_APIENTRY _impl_glUniform4uiv (GLint location, GLsizei count, const GLuint * value) {
  _glptr_glUniform4uiv = (PFN_glUniform4uiv)GalogenGetProcAddress("glUniform4uiv");
   _glptr_glUniform4uiv(location, count, value);
}
PFN_glUniform4uiv _glptr_glUniform4uiv = _impl_glUniform4uiv;

static void  GL_APIENTRY _impl_glUniform3ui (GLint location, GLuint v0, GLuint v1, GLuint v2) {
  _glptr_glUniform3ui = (PFN_glUniform3ui)GalogenGetProcAddress("glUniform3ui");
   _glptr_glUniform3ui(location, v0, v1, v2);
}
PFN_glUniform3ui _glptr_glUniform3ui = _impl_glUniform3ui;

static void  GL_APIENTRY _impl_glUniform1ui (GLint location, GLuint v0) {
  _glptr_glUniform1ui = (PFN_glUniform1ui)GalogenGetProcAddress("glUniform1ui");
   _glptr_glUniform1ui(location, v0);
}
PFN_glUniform1ui _glptr_glUniform1ui = _impl_glUniform1ui;

static GLint GL_APIENTRY _impl_glGetFragDataLocation (GLuint program, const GLchar * name) {
  _glptr_glGetFragDataLocation = (PFN_glGetFragDataLocation)GalogenGetProcAddress("glGetFragDataLocation");
  return _glptr_glGetFragDataLocation(program, name);
}
PFN_glGetFragDataLocation _glptr_glGetFragDataLocation = _impl_glGetFragDataLocation;

static void  GL_APIENTRY _impl_glBindFragDataLocation (GLuint program, GLuint color, const GLchar * name) {
  _glptr_glBindFragDataLocation = (PFN_glBindFragDataLocation)GalogenGetProcAddress("glBindFragDataLocation");
   _glptr_glBindFragDataLocation(program, color, name);
}
PFN_glBindFragDataLocation _glptr_glBindFragDataLocation = _impl_glBindFragDataLocation;

static void  GL_APIENTRY _impl_glVertexAttribI4iv (GLuint index, const GLint * v) {
  _glptr_glVertexAttribI4iv = (PFN_glVertexAttribI4iv)GalogenGetProcAddress("glVertexAttribI4iv");
   _glptr_glVertexAttribI4iv(index, v);
}
PFN_glVertexAttribI4iv _glptr_glVertexAttribI4iv = _impl_glVertexAttribI4iv;

static void  GL_APIENTRY _impl_glVertexAttribI2iv (GLuint index, const GLint * v) {
  _glptr_glVertexAttribI2iv = (PFN_glVertexAttribI2iv)GalogenGetProcAddress("glVertexAttribI2iv");
   _glptr_glVertexAttribI2iv(index, v);
}
PFN_glVertexAttribI2iv _glptr_glVertexAttribI2iv = _impl_glVertexAttribI2iv;

static void  GL_APIENTRY _impl_glVertexAttribI1iv (GLuint index, const GLint * v) {
  _glptr_glVertexAttribI1iv = (PFN_glVertexAttribI1iv)GalogenGetProcAddress("glVertexAttribI1iv");
   _glptr_glVertexAttribI1iv(index, v);
}
PFN_glVertexAttribI1iv _glptr_glVertexAttribI1iv = _impl_glVertexAttribI1iv;

static void  GL_APIENTRY _impl_glVertexAttribI4ui (GLuint index, GLuint x, GLuint y, GLuint z, GLuint w) {
  _glptr_glVertexAttribI4ui = (PFN_glVertexAttribI4ui)GalogenGetProcAddress("glVertexAttribI4ui");
   _glptr_glVertexAttribI4ui(index, x, y, z, w);
}
PFN_glVertexAttribI4ui _glptr_glVertexAttribI4ui = _impl_glVertexAttribI4ui;

static void  GL_APIENTRY _impl_glVertexAttribI2ui (GLuint index, GLuint x, GLuint y) {
  _glptr_glVertexAttribI2ui = (PFN_glVertexAttribI2ui)GalogenGetProcAddress("glVertexAttribI2ui");
   _glptr_glVertexAttribI2ui(index, x, y);
}
PFN_glVertexAttribI2ui _glptr_glVertexAttribI2ui = _impl_glVertexAttribI2ui;

static void  GL_APIENTRY _impl_glVertexAttribI1ui (GLuint index, GLuint x) {
  _glptr_glVertexAttribI1ui = (PFN_glVertexAttribI1ui)GalogenGetProcAddress("glVertexAttribI1ui");
   _glptr_glVertexAttribI1ui(index, x);
}
PFN_glVertexAttribI1ui _glptr_glVertexAttribI1ui = _impl_glVertexAttribI1ui;

static void  GL_APIENTRY _impl_glVertexAttribI4i (GLuint index, GLint x, GLint y, GLint z, GLint w) {
  _glptr_glVertexAttribI4i = (PFN_glVertexAttribI4i)GalogenGetProcAddress("glVertexAttribI4i");
   _glptr_glVertexAttribI4i(index, x, y, z, w);
}
PFN_glVertexAttribI4i _glptr_glVertexAttribI4i = _impl_glVertexAttribI4i;

static void  GL_APIENTRY _impl_glVertexAttribI4bv (GLuint index, const GLbyte * v) {
  _glptr_glVertexAttribI4bv = (PFN_glVertexAttribI4bv)GalogenGetProcAddress("glVertexAttribI4bv");
   _glptr_glVertexAttribI4bv(index, v);
}
PFN_glVertexAttribI4bv _glptr_glVertexAttribI4bv = _impl_glVertexAttribI4bv;

static void  GL_APIENTRY _impl_glVertexAttribI2i (GLuint index, GLint x, GLint y) {
  _glptr_glVertexAttribI2i = (PFN_glVertexAttribI2i)GalogenGetProcAddress("glVertexAttribI2i");
   _glptr_glVertexAttribI2i(index, x, y);
}
PFN_glVertexAttribI2i _glptr_glVertexAttribI2i = _impl_glVertexAttribI2i;

static void  GL_APIENTRY _impl_glVertexAttribI1i (GLuint index, GLint x) {
  _glptr_glVertexAttribI1i = (PFN_glVertexAttribI1i)GalogenGetProcAddress("glVertexAttribI1i");
   _glptr_glVertexAttribI1i(index, x);
}
PFN_glVertexAttribI1i _glptr_glVertexAttribI1i = _impl_glVertexAttribI1i;

static void  GL_APIENTRY _impl_glGetVertexAttribIiv (GLuint index, GLenum pname, GLint * params) {
  _glptr_glGetVertexAttribIiv = (PFN_glGetVertexAttribIiv)GalogenGetProcAddress("glGetVertexAttribIiv");
   _glptr_glGetVertexAttribIiv(index, pname, params);
}
PFN_glGetVertexAttribIiv _glptr_glGetVertexAttribIiv = _impl_glGetVertexAttribIiv;

static void  GL_APIENTRY _impl_glVertexAttribIPointer (GLuint index, GLint size, GLenum type, GLsizei stride, const void * pointer) {
  _glptr_glVertexAttribIPointer = (PFN_glVertexAttribIPointer)GalogenGetProcAddress("glVertexAttribIPointer");
   _glptr_glVertexAttribIPointer(index, size, type, stride, pointer);
}
PFN_glVertexAttribIPointer _glptr_glVertexAttribIPointer = _impl_glVertexAttribIPointer;

static void  GL_APIENTRY _impl_glBeginConditionalRender (GLuint id, GLenum mode) {
  _glptr_glBeginConditionalRender = (PFN_glBeginConditionalRender)GalogenGetProcAddress("glBeginConditionalRender");
   _glptr_glBeginConditionalRender(id, mode);
}
PFN_glBeginConditionalRender _glptr_glBeginConditionalRender = _impl_glBeginConditionalRender;

static void  GL_APIENTRY _impl_glClampColor (GLenum target, GLenum clamp) {
  _glptr_glClampColor = (PFN_glClampColor)GalogenGetProcAddress("glClampColor");
   _glptr_glClampColor(target, clamp);
}
PFN_glClampColor _glptr_glClampColor = _impl_glClampColor;

static void  GL_APIENTRY _impl_glBindBufferBase (GLenum target, GLuint index, GLuint buffer) {
  _glptr_glBindBufferBase = (PFN_glBindBufferBase)GalogenGetProcAddress("glBindBufferBase");
   _glptr_glBindBufferBase(target, index, buffer);
}
PFN_glBindBufferBase _glptr_glBindBufferBase = _impl_glBindBufferBase;

static void  GL_APIENTRY _impl_glBindBufferRange (GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size) {
  _glptr_glBindBufferRange = (PFN_glBindBufferRange)GalogenGetProcAddress("glBindBufferRange");
   _glptr_glBindBufferRange(target, index, buffer, offset, size);
}
PFN_glBindBufferRange _glptr_glBindBufferRange = _impl_glBindBufferRange;

static void  GL_APIENTRY _impl_glBeginTransformFeedback (GLenum primitiveMode) {
  _glptr_glBeginTransformFeedback = (PFN_glBeginTransformFeedback)GalogenGetProcAddress("glBeginTransformFeedback");
   _glptr_glBeginTransformFeedback(primitiveMode);
}
PFN_glBeginTransformFeedback _glptr_glBeginTransformFeedback = _impl_glBeginTransformFeedback;

static GLboolean GL_APIENTRY _impl_glIsEnabledi (GLenum target, GLuint index) {
  _glptr_glIsEnabledi = (PFN_glIsEnabledi)GalogenGetProcAddress("glIsEnabledi");
  return _glptr_glIsEnabledi(target, index);
}
PFN_glIsEnabledi _glptr_glIsEnabledi = _impl_glIsEnabledi;

static void  GL_APIENTRY _impl_glGetIntegeri_v (GLenum target, GLuint index, GLint * data) {
  _glptr_glGetIntegeri_v = (PFN_glGetIntegeri_v)GalogenGetProcAddress("glGetIntegeri_v");
   _glptr_glGetIntegeri_v(target, index, data);
}
PFN_glGetIntegeri_v _glptr_glGetIntegeri_v = _impl_glGetIntegeri_v;

static void  GL_APIENTRY _impl_glColorMaski (GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a) {
  _glptr_glColorMaski = (PFN_glColorMaski)GalogenGetProcAddress("glColorMaski");
   _glptr_glColorMaski(index, r, g, b, a);
}
PFN_glColorMaski _glptr_glColorMaski = _impl_glColorMaski;

static void  GL_APIENTRY _impl_glUniformMatrix4x3fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
  _glptr_glUniformMatrix4x3fv = (PFN_glUniformMatrix4x3fv)GalogenGetProcAddress("glUniformMatrix4x3fv");
   _glptr_glUniformMatrix4x3fv(location, count, transpose, value);
}
PFN_glUniformMatrix4x3fv _glptr_glUniformMatrix4x3fv = _impl_glUniformMatrix4x3fv;

static void  GL_APIENTRY _impl_glUniformMatrix3x4fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
  _glptr_glUniformMatrix3x4fv = (PFN_glUniformMatrix3x4fv)GalogenGetProcAddress("glUniformMatrix3x4fv");
   _glptr_glUniformMatrix3x4fv(location, count, transpose, value);
}
PFN_glUniformMatrix3x4fv _glptr_glUniformMatrix3x4fv = _impl_glUniformMatrix3x4fv;

static void  GL_APIENTRY _impl_glUniformMatrix2x4fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
  _glptr_glUniformMatrix2x4fv = (PFN_glUniformMatrix2x4fv)GalogenGetProcAddress("glUniformMatrix2x4fv");
   _glptr_glUniformMatrix2x4fv(location, count, transpose, value);
}
PFN_glUniformMatrix2x4fv _glptr_glUniformMatrix2x4fv = _impl_glUniformMatrix2x4fv;

static void  GL_APIENTRY _impl_glUniformMatrix3x2fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
  _glptr_glUniformMatrix3x2fv = (PFN_glUniformMatrix3x2fv)GalogenGetProcAddress("glUniformMatrix3x2fv");
   _glptr_glUniformMatrix3x2fv(location, count, transpose, value);
}
PFN_glUniformMatrix3x2fv _glptr_glUniformMatrix3x2fv = _impl_glUniformMatrix3x2fv;

static void  GL_APIENTRY _impl_glUniformMatrix2x3fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
  _glptr_glUniformMatrix2x3fv = (PFN_glUniformMatrix2x3fv)GalogenGetProcAddress("glUniformMatrix2x3fv");
   _glptr_glUniformMatrix2x3fv(location, count, transpose, value);
}
PFN_glUniformMatrix2x3fv _glptr_glUniformMatrix2x3fv = _impl_glUniformMatrix2x3fv;

static void  GL_APIENTRY _impl_glVertexAttribP4ui (GLuint index, GLenum type, GLboolean normalized, GLuint value) {
  _glptr_glVertexAttribP4ui = (PFN_glVertexAttribP4ui)GalogenGetProcAddress("glVertexAttribP4ui");
   _glptr_glVertexAttribP4ui(index, type, normalized, value);
}
PFN_glVertexAttribP4ui _glptr_glVertexAttribP4ui = _impl_glVertexAttribP4ui;

static void  GL_APIENTRY _impl_glVertexAttrib4ubv (GLuint index, const GLubyte * v) {
  _glptr_glVertexAttrib4ubv = (PFN_glVertexAttrib4ubv)GalogenGetProcAddress("glVertexAttrib4ubv");
   _glptr_glVertexAttrib4ubv(index, v);
}
PFN_glVertexAttrib4ubv _glptr_glVertexAttrib4ubv = _impl_glVertexAttrib4ubv;

static void  GL_APIENTRY _impl_glVertexAttrib4sv (GLuint index, const GLshort * v) {
  _glptr_glVertexAttrib4sv = (PFN_glVertexAttrib4sv)GalogenGetProcAddress("glVertexAttrib4sv");
   _glptr_glVertexAttrib4sv(index, v);
}
PFN_glVertexAttrib4sv _glptr_glVertexAttrib4sv = _impl_glVertexAttrib4sv;

static void  GL_APIENTRY _impl_glVertexAttrib4fv (GLuint index, const GLfloat * v) {
  _glptr_glVertexAttrib4fv = (PFN_glVertexAttrib4fv)GalogenGetProcAddress("glVertexAttrib4fv");
   _glptr_glVertexAttrib4fv(index, v);
}
PFN_glVertexAttrib4fv _glptr_glVertexAttrib4fv = _impl_glVertexAttrib4fv;

static void  GL_APIENTRY _impl_glVertexAttrib4Nusv (GLuint index, const GLushort * v) {
  _glptr_glVertexAttrib4Nusv = (PFN_glVertexAttrib4Nusv)GalogenGetProcAddress("glVertexAttrib4Nusv");
   _glptr_glVertexAttrib4Nusv(index, v);
}
PFN_glVertexAttrib4Nusv _glptr_glVertexAttrib4Nusv = _impl_glVertexAttrib4Nusv;

static void  GL_APIENTRY _impl_glVertexAttrib4Nuiv (GLuint index, const GLuint * v) {
  _glptr_glVertexAttrib4Nuiv = (PFN_glVertexAttrib4Nuiv)GalogenGetProcAddress("glVertexAttrib4Nuiv");
   _glptr_glVertexAttrib4Nuiv(index, v);
}
PFN_glVertexAttrib4Nuiv _glptr_glVertexAttrib4Nuiv = _impl_glVertexAttrib4Nuiv;

static void  GL_APIENTRY _impl_glVertexAttrib4Nubv (GLuint index, const GLubyte * v) {
  _glptr_glVertexAttrib4Nubv = (PFN_glVertexAttrib4Nubv)GalogenGetProcAddress("glVertexAttrib4Nubv");
   _glptr_glVertexAttrib4Nubv(index, v);
}
PFN_glVertexAttrib4Nubv _glptr_glVertexAttrib4Nubv = _impl_glVertexAttrib4Nubv;

static void  GL_APIENTRY _impl_glProvokingVertex (GLenum mode) {
  _glptr_glProvokingVertex = (PFN_glProvokingVertex)GalogenGetProcAddress("glProvokingVertex");
   _glptr_glProvokingVertex(mode);
}
PFN_glProvokingVertex _glptr_glProvokingVertex = _impl_glProvokingVertex;

static void  GL_APIENTRY _impl_glVertexAttrib4Nsv (GLuint index, const GLshort * v) {
  _glptr_glVertexAttrib4Nsv = (PFN_glVertexAttrib4Nsv)GalogenGetProcAddress("glVertexAttrib4Nsv");
   _glptr_glVertexAttrib4Nsv(index, v);
}
PFN_glVertexAttrib4Nsv _glptr_glVertexAttrib4Nsv = _impl_glVertexAttrib4Nsv;

static void  GL_APIENTRY _impl_glVertexAttrib3f (GLuint index, GLfloat x, GLfloat y, GLfloat z) {
  _glptr_glVertexAttrib3f = (PFN_glVertexAttrib3f)GalogenGetProcAddress("glVertexAttrib3f");
   _glptr_glVertexAttrib3f(index, x, y, z);
}
PFN_glVertexAttrib3f _glptr_glVertexAttrib3f = _impl_glVertexAttrib3f;

static void  GL_APIENTRY _impl_glVertexAttribI1uiv (GLuint index, const GLuint * v) {
  _glptr_glVertexAttribI1uiv = (PFN_glVertexAttribI1uiv)GalogenGetProcAddress("glVertexAttribI1uiv");
   _glptr_glVertexAttribI1uiv(index, v);
}
PFN_glVertexAttribI1uiv _glptr_glVertexAttribI1uiv = _impl_glVertexAttribI1uiv;

static void  GL_APIENTRY _impl_glVertexAttrib3dv (GLuint index, const GLdouble * v) {
  _glptr_glVertexAttrib3dv = (PFN_glVertexAttrib3dv)GalogenGetProcAddress("glVertexAttrib3dv");
   _glptr_glVertexAttrib3dv(index, v);
}
PFN_glVertexAttrib3dv _glptr_glVertexAttrib3dv = _impl_glVertexAttrib3dv;

static void  GL_APIENTRY _impl_glVertexAttrib3d (GLuint index, GLdouble x, GLdouble y, GLdouble z) {
  _glptr_glVertexAttrib3d = (PFN_glVertexAttrib3d)GalogenGetProcAddress("glVertexAttrib3d");
   _glptr_glVertexAttrib3d(index, x, y, z);
}
PFN_glVertexAttrib3d _glptr_glVertexAttrib3d = _impl_glVertexAttrib3d;

static void  GL_APIENTRY _impl_glVertexAttrib2sv (GLuint index, const GLshort * v) {
  _glptr_glVertexAttrib2sv = (PFN_glVertexAttrib2sv)GalogenGetProcAddress("glVertexAttrib2sv");
   _glptr_glVertexAttrib2sv(index, v);
}
PFN_glVertexAttrib2sv _glptr_glVertexAttrib2sv = _impl_glVertexAttrib2sv;

static void  GL_APIENTRY _impl_glVertexAttrib2fv (GLuint index, const GLfloat * v) {
  _glptr_glVertexAttrib2fv = (PFN_glVertexAttrib2fv)GalogenGetProcAddress("glVertexAttrib2fv");
   _glptr_glVertexAttrib2fv(index, v);
}
PFN_glVertexAttrib2fv _glptr_glVertexAttrib2fv = _impl_glVertexAttrib2fv;

static void  GL_APIENTRY _impl_glVertexAttrib2dv (GLuint index, const GLdouble * v) {
  _glptr_glVertexAttrib2dv = (PFN_glVertexAttrib2dv)GalogenGetProcAddress("glVertexAttrib2dv");
   _glptr_glVertexAttrib2dv(index, v);
}
PFN_glVertexAttrib2dv _glptr_glVertexAttrib2dv = _impl_glVertexAttrib2dv;

static void  GL_APIENTRY _impl_glVertexAttrib2d (GLuint index, GLdouble x, GLdouble y) {
  _glptr_glVertexAttrib2d = (PFN_glVertexAttrib2d)GalogenGetProcAddress("glVertexAttrib2d");
   _glptr_glVertexAttrib2d(index, x, y);
}
PFN_glVertexAttrib2d _glptr_glVertexAttrib2d = _impl_glVertexAttrib2d;

static void  GL_APIENTRY _impl_glVertexAttrib2f (GLuint index, GLfloat x, GLfloat y) {
  _glptr_glVertexAttrib2f = (PFN_glVertexAttrib2f)GalogenGetProcAddress("glVertexAttrib2f");
   _glptr_glVertexAttrib2f(index, x, y);
}
PFN_glVertexAttrib2f _glptr_glVertexAttrib2f = _impl_glVertexAttrib2f;

static void  GL_APIENTRY _impl_glVertexAttrib1s (GLuint index, GLshort x) {
  _glptr_glVertexAttrib1s = (PFN_glVertexAttrib1s)GalogenGetProcAddress("glVertexAttrib1s");
   _glptr_glVertexAttrib1s(index, x);
}
PFN_glVertexAttrib1s _glptr_glVertexAttrib1s = _impl_glVertexAttrib1s;

static void  GL_APIENTRY _impl_glVertexAttrib1fv (GLuint index, const GLfloat * v) {
  _glptr_glVertexAttrib1fv = (PFN_glVertexAttrib1fv)GalogenGetProcAddress("glVertexAttrib1fv");
   _glptr_glVertexAttrib1fv(index, v);
}
PFN_glVertexAttrib1fv _glptr_glVertexAttrib1fv = _impl_glVertexAttrib1fv;

static void  GL_APIENTRY _impl_glVertexAttrib1f (GLuint index, GLfloat x) {
  _glptr_glVertexAttrib1f = (PFN_glVertexAttrib1f)GalogenGetProcAddress("glVertexAttrib1f");
   _glptr_glVertexAttrib1f(index, x);
}
PFN_glVertexAttrib1f _glptr_glVertexAttrib1f = _impl_glVertexAttrib1f;

static void  GL_APIENTRY _impl_glVertexAttrib1dv (GLuint index, const GLdouble * v) {
  _glptr_glVertexAttrib1dv = (PFN_glVertexAttrib1dv)GalogenGetProcAddress("glVertexAttrib1dv");
   _glptr_glVertexAttrib1dv(index, v);
}
PFN_glVertexAttrib1dv _glptr_glVertexAttrib1dv = _impl_glVertexAttrib1dv;

static void  GL_APIENTRY _impl_glClearBufferuiv (GLenum buffer, GLint drawbuffer, const GLuint * value) {
  _glptr_glClearBufferuiv = (PFN_glClearBufferuiv)GalogenGetProcAddress("glClearBufferuiv");
   _glptr_glClearBufferuiv(buffer, drawbuffer, value);
}
PFN_glClearBufferuiv _glptr_glClearBufferuiv = _impl_glClearBufferuiv;

static void  GL_APIENTRY _impl_glUniformMatrix3fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
  _glptr_glUniformMatrix3fv = (PFN_glUniformMatrix3fv)GalogenGetProcAddress("glUniformMatrix3fv");
   _glptr_glUniformMatrix3fv(location, count, transpose, value);
}
PFN_glUniformMatrix3fv _glptr_glUniformMatrix3fv = _impl_glUniformMatrix3fv;

static void  GL_APIENTRY _impl_glDeleteRenderbuffers (GLsizei n, const GLuint * renderbuffers) {
  _glptr_glDeleteRenderbuffers = (PFN_glDeleteRenderbuffers)GalogenGetProcAddress("glDeleteRenderbuffers");
   _glptr_glDeleteRenderbuffers(n, renderbuffers);
}
PFN_glDeleteRenderbuffers _glptr_glDeleteRenderbuffers = _impl_glDeleteRenderbuffers;

static void  GL_APIENTRY _impl_glUniformMatrix2fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
  _glptr_glUniformMatrix2fv = (PFN_glUniformMatrix2fv)GalogenGetProcAddress("glUniformMatrix2fv");
   _glptr_glUniformMatrix2fv(location, count, transpose, value);
}
PFN_glUniformMatrix2fv _glptr_glUniformMatrix2fv = _impl_glUniformMatrix2fv;

static void  GL_APIENTRY _impl_glUniform4iv (GLint location, GLsizei count, const GLint * value) {
  _glptr_glUniform4iv = (PFN_glUniform4iv)GalogenGetProcAddress("glUniform4iv");
   _glptr_glUniform4iv(location, count, value);
}
PFN_glUniform4iv _glptr_glUniform4iv = _impl_glUniform4iv;

static void  GL_APIENTRY _impl_glUniform1iv (GLint location, GLsizei count, const GLint * value) {
  _glptr_glUniform1iv = (PFN_glUniform1iv)GalogenGetProcAddress("glUniform1iv");
   _glptr_glUniform1iv(location, count, value);
}
PFN_glUniform1iv _glptr_glUniform1iv = _impl_glUniform1iv;

static void  GL_APIENTRY _impl_glUniform4fv (GLint location, GLsizei count, const GLfloat * value) {
  _glptr_glUniform4fv = (PFN_glUniform4fv)GalogenGetProcAddress("glUniform4fv");
   _glptr_glUniform4fv(location, count, value);
}
PFN_glUniform4fv _glptr_glUniform4fv = _impl_glUniform4fv;

static void  GL_APIENTRY _impl_glUniform2fv (GLint location, GLsizei count, const GLfloat * value) {
  _glptr_glUniform2fv = (PFN_glUniform2fv)GalogenGetProcAddress("glUniform2fv");
   _glptr_glUniform2fv(location, count, value);
}
PFN_glUniform2fv _glptr_glUniform2fv = _impl_glUniform2fv;

static void  GL_APIENTRY _impl_glUniform3i (GLint location, GLint v0, GLint v1, GLint v2) {
  _glptr_glUniform3i = (PFN_glUniform3i)GalogenGetProcAddress("glUniform3i");
   _glptr_glUniform3i(location, v0, v1, v2);
}
PFN_glUniform3i _glptr_glUniform3i = _impl_glUniform3i;

static void  GL_APIENTRY _impl_glUniform2i (GLint location, GLint v0, GLint v1) {
  _glptr_glUniform2i = (PFN_glUniform2i)GalogenGetProcAddress("glUniform2i");
   _glptr_glUniform2i(location, v0, v1);
}
PFN_glUniform2i _glptr_glUniform2i = _impl_glUniform2i;

static void  GL_APIENTRY _impl_glUniform4f (GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3) {
  _glptr_glUniform4f = (PFN_glUniform4f)GalogenGetProcAddress("glUniform4f");
   _glptr_glUniform4f(location, v0, v1, v2, v3);
}
PFN_glUniform4f _glptr_glUniform4f = _impl_glUniform4f;

static void  GL_APIENTRY _impl_glUniform3f (GLint location, GLfloat v0, GLfloat v1, GLfloat v2) {
  _glptr_glUniform3f = (PFN_glUniform3f)GalogenGetProcAddress("glUniform3f");
   _glptr_glUniform3f(location, v0, v1, v2);
}
PFN_glUniform3f _glptr_glUniform3f = _impl_glUniform3f;

static void  GL_APIENTRY _impl_glUniform1f (GLint location, GLfloat v0) {
  _glptr_glUniform1f = (PFN_glUniform1f)GalogenGetProcAddress("glUniform1f");
   _glptr_glUniform1f(location, v0);
}
PFN_glUniform1f _glptr_glUniform1f = _impl_glUniform1f;

static void  GL_APIENTRY _impl_glUseProgram (GLuint program) {
  _glptr_glUseProgram = (PFN_glUseProgram)GalogenGetProcAddress("glUseProgram");
   _glptr_glUseProgram(program);
}
PFN_glUseProgram _glptr_glUseProgram = _impl_glUseProgram;

static void  GL_APIENTRY _impl_glShaderSource (GLuint shader, GLsizei count, const GLchar *const* string, const GLint * length) {
  _glptr_glShaderSource = (PFN_glShaderSource)GalogenGetProcAddress("glShaderSource");
   _glptr_glShaderSource(shader, count, string, length);
}
PFN_glShaderSource _glptr_glShaderSource = _impl_glShaderSource;

static void  GL_APIENTRY _impl_glLinkProgram (GLuint program) {
  _glptr_glLinkProgram = (PFN_glLinkProgram)GalogenGetProcAddress("glLinkProgram");
   _glptr_glLinkProgram(program);
}
PFN_glLinkProgram _glptr_glLinkProgram = _impl_glLinkProgram;

static GLboolean GL_APIENTRY _impl_glIsShader (GLuint shader) {
  _glptr_glIsShader = (PFN_glIsShader)GalogenGetProcAddress("glIsShader");
  return _glptr_glIsShader(shader);
}
PFN_glIsShader _glptr_glIsShader = _impl_glIsShader;

static void  GL_APIENTRY _impl_glGetVertexAttribPointerv (GLuint index, GLenum pname, void ** pointer) {
  _glptr_glGetVertexAttribPointerv = (PFN_glGetVertexAttribPointerv)GalogenGetProcAddress("glGetVertexAttribPointerv");
   _glptr_glGetVertexAttribPointerv(index, pname, pointer);
}
PFN_glGetVertexAttribPointerv _glptr_glGetVertexAttribPointerv = _impl_glGetVertexAttribPointerv;

static void  GL_APIENTRY _impl_glGetVertexAttribiv (GLuint index, GLenum pname, GLint * params) {
  _glptr_glGetVertexAttribiv = (PFN_glGetVertexAttribiv)GalogenGetProcAddress("glGetVertexAttribiv");
   _glptr_glGetVertexAttribiv(index, pname, params);
}
PFN_glGetVertexAttribiv _glptr_glGetVertexAttribiv = _impl_glGetVertexAttribiv;

static void  GL_APIENTRY _impl_glGetVertexAttribfv (GLuint index, GLenum pname, GLfloat * params) {
  _glptr_glGetVertexAttribfv = (PFN_glGetVertexAttribfv)GalogenGetProcAddress("glGetVertexAttribfv");
   _glptr_glGetVertexAttribfv(index, pname, params);
}
PFN_glGetVertexAttribfv _glptr_glGetVertexAttribfv = _impl_glGetVertexAttribfv;

static void  GL_APIENTRY _impl_glUniformBlockBinding (GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding) {
  _glptr_glUniformBlockBinding = (PFN_glUniformBlockBinding)GalogenGetProcAddress("glUniformBlockBinding");
   _glptr_glUniformBlockBinding(program, uniformBlockIndex, uniformBlockBinding);
}
PFN_glUniformBlockBinding _glptr_glUniformBlockBinding = _impl_glUniformBlockBinding;

static GLint GL_APIENTRY _impl_glGetUniformLocation (GLuint program, const GLchar * name) {
  _glptr_glGetUniformLocation = (PFN_glGetUniformLocation)GalogenGetProcAddress("glGetUniformLocation");
  return _glptr_glGetUniformLocation(program, name);
}
PFN_glGetUniformLocation _glptr_glGetUniformLocation = _impl_glGetUniformLocation;

static void  GL_APIENTRY _impl_glGetShaderiv (GLuint shader, GLenum pname, GLint * params) {
  _glptr_glGetShaderiv = (PFN_glGetShaderiv)GalogenGetProcAddress("glGetShaderiv");
   _glptr_glGetShaderiv(shader, pname, params);
}
PFN_glGetShaderiv _glptr_glGetShaderiv = _impl_glGetShaderiv;

static void  GL_APIENTRY _impl_glGetProgramInfoLog (GLuint program, GLsizei bufSize, GLsizei * length, GLchar * infoLog) {
  _glptr_glGetProgramInfoLog = (PFN_glGetProgramInfoLog)GalogenGetProcAddress("glGetProgramInfoLog");
   _glptr_glGetProgramInfoLog(program, bufSize, length, infoLog);
}
PFN_glGetProgramInfoLog _glptr_glGetProgramInfoLog = _impl_glGetProgramInfoLog;

static GLint GL_APIENTRY _impl_glGetAttribLocation (GLuint program, const GLchar * name) {
  _glptr_glGetAttribLocation = (PFN_glGetAttribLocation)GalogenGetProcAddress("glGetAttribLocation");
  return _glptr_glGetAttribLocation(program, name);
}
PFN_glGetAttribLocation _glptr_glGetAttribLocation = _impl_glGetAttribLocation;

static void  GL_APIENTRY _impl_glGetAttachedShaders (GLuint program, GLsizei maxCount, GLsizei * count, GLuint * shaders) {
  _glptr_glGetAttachedShaders = (PFN_glGetAttachedShaders)GalogenGetProcAddress("glGetAttachedShaders");
   _glptr_glGetAttachedShaders(program, maxCount, count, shaders);
}
PFN_glGetAttachedShaders _glptr_glGetAttachedShaders = _impl_glGetAttachedShaders;

static void  GL_APIENTRY _impl_glGetActiveUniform (GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name) {
  _glptr_glGetActiveUniform = (PFN_glGetActiveUniform)GalogenGetProcAddress("glGetActiveUniform");
   _glptr_glGetActiveUniform(program, index, bufSize, length, size, type, name);
}
PFN_glGetActiveUniform _glptr_glGetActiveUniform = _impl_glGetActiveUniform;

static void  GL_APIENTRY _impl_glGetActiveAttrib (GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name) {
  _glptr_glGetActiveAttrib = (PFN_glGetActiveAttrib)GalogenGetProcAddress("glGetActiveAttrib");
   _glptr_glGetActiveAttrib(program, index, bufSize, length, size, type, name);
}
PFN_glGetActiveAttrib _glptr_glGetActiveAttrib = _impl_glGetActiveAttrib;

static void  GL_APIENTRY _impl_glVertexAttrib4iv (GLuint index, const GLint * v) {
  _glptr_glVertexAttrib4iv = (PFN_glVertexAttrib4iv)GalogenGetProcAddress("glVertexAttrib4iv");
   _glptr_glVertexAttrib4iv(index, v);
}
PFN_glVertexAttrib4iv _glptr_glVertexAttrib4iv = _impl_glVertexAttrib4iv;

static void  GL_APIENTRY _impl_glDisableVertexAttribArray (GLuint index) {
  _glptr_glDisableVertexAttribArray = (PFN_glDisableVertexAttribArray)GalogenGetProcAddress("glDisableVertexAttribArray");
   _glptr_glDisableVertexAttribArray(index);
}
PFN_glDisableVertexAttribArray _glptr_glDisableVertexAttribArray = _impl_glDisableVertexAttribArray;

static void  GL_APIENTRY _impl_glDeleteShader (GLuint shader) {
  _glptr_glDeleteShader = (PFN_glDeleteShader)GalogenGetProcAddress("glDeleteShader");
   _glptr_glDeleteShader(shader);
}
PFN_glDeleteShader _glptr_glDeleteShader = _impl_glDeleteShader;

static void  GL_APIENTRY _impl_glDeleteProgram (GLuint program) {
  _glptr_glDeleteProgram = (PFN_glDeleteProgram)GalogenGetProcAddress("glDeleteProgram");
   _glptr_glDeleteProgram(program);
}
PFN_glDeleteProgram _glptr_glDeleteProgram = _impl_glDeleteProgram;

static void  GL_APIENTRY _impl_glGetBooleani_v (GLenum target, GLuint index, GLboolean * data) {
  _glptr_glGetBooleani_v = (PFN_glGetBooleani_v)GalogenGetProcAddress("glGetBooleani_v");
   _glptr_glGetBooleani_v(target, index, data);
}
PFN_glGetBooleani_v _glptr_glGetBooleani_v = _impl_glGetBooleani_v;

static void  GL_APIENTRY _impl_glCompileShader (GLuint shader) {
  _glptr_glCompileShader = (PFN_glCompileShader)GalogenGetProcAddress("glCompileShader");
   _glptr_glCompileShader(shader);
}
PFN_glCompileShader _glptr_glCompileShader = _impl_glCompileShader;

static void  GL_APIENTRY _impl_glStencilFuncSeparate (GLenum face, GLenum func, GLint ref, GLuint mask) {
  _glptr_glStencilFuncSeparate = (PFN_glStencilFuncSeparate)GalogenGetProcAddress("glStencilFuncSeparate");
   _glptr_glStencilFuncSeparate(face, func, ref, mask);
}
PFN_glStencilFuncSeparate _glptr_glStencilFuncSeparate = _impl_glStencilFuncSeparate;

static void  GL_APIENTRY _impl_glStencilOpSeparate (GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass) {
  _glptr_glStencilOpSeparate = (PFN_glStencilOpSeparate)GalogenGetProcAddress("glStencilOpSeparate");
   _glptr_glStencilOpSeparate(face, sfail, dpfail, dppass);
}
PFN_glStencilOpSeparate _glptr_glStencilOpSeparate = _impl_glStencilOpSeparate;

static void  GL_APIENTRY _impl_glRenderbufferStorageMultisample (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
  _glptr_glRenderbufferStorageMultisample = (PFN_glRenderbufferStorageMultisample)GalogenGetProcAddress("glRenderbufferStorageMultisample");
   _glptr_glRenderbufferStorageMultisample(target, samples, internalformat, width, height);
}
PFN_glRenderbufferStorageMultisample _glptr_glRenderbufferStorageMultisample = _impl_glRenderbufferStorageMultisample;

static void  GL_APIENTRY _impl_glDrawBuffers (GLsizei n, const GLenum * bufs) {
  _glptr_glDrawBuffers = (PFN_glDrawBuffers)GalogenGetProcAddress("glDrawBuffers");
   _glptr_glDrawBuffers(n, bufs);
}
PFN_glDrawBuffers _glptr_glDrawBuffers = _impl_glDrawBuffers;

static void  GL_APIENTRY _impl_glGetBufferParameteriv (GLenum target, GLenum pname, GLint * params) {
  _glptr_glGetBufferParameteriv = (PFN_glGetBufferParameteriv)GalogenGetProcAddress("glGetBufferParameteriv");
   _glptr_glGetBufferParameteriv(target, pname, params);
}
PFN_glGetBufferParameteriv _glptr_glGetBufferParameteriv = _impl_glGetBufferParameteriv;

static void  GL_APIENTRY _impl_glVertexAttribDivisor (GLuint index, GLuint divisor) {
  _glptr_glVertexAttribDivisor = (PFN_glVertexAttribDivisor)GalogenGetProcAddress("glVertexAttribDivisor");
   _glptr_glVertexAttribDivisor(index, divisor);
}
PFN_glVertexAttribDivisor _glptr_glVertexAttribDivisor = _impl_glVertexAttribDivisor;

static GLboolean GL_APIENTRY _impl_glUnmapBuffer (GLenum target) {
  _glptr_glUnmapBuffer = (PFN_glUnmapBuffer)GalogenGetProcAddress("glUnmapBuffer");
  return _glptr_glUnmapBuffer(target);
}
PFN_glUnmapBuffer _glptr_glUnmapBuffer = _impl_glUnmapBuffer;

static void  GL_APIENTRY _impl_glVertexAttrib4dv (GLuint index, const GLdouble * v) {
  _glptr_glVertexAttrib4dv = (PFN_glVertexAttrib4dv)GalogenGetProcAddress("glVertexAttrib4dv");
   _glptr_glVertexAttrib4dv(index, v);
}
PFN_glVertexAttrib4dv _glptr_glVertexAttrib4dv = _impl_glVertexAttrib4dv;

static void * GL_APIENTRY _impl_glMapBuffer (GLenum target, GLenum access) {
  _glptr_glMapBuffer = (PFN_glMapBuffer)GalogenGetProcAddress("glMapBuffer");
  return _glptr_glMapBuffer(target, access);
}
PFN_glMapBuffer _glptr_glMapBuffer = _impl_glMapBuffer;

static void  GL_APIENTRY _impl_glBufferSubData (GLenum target, GLintptr offset, GLsizeiptr size, const void * data) {
  _glptr_glBufferSubData = (PFN_glBufferSubData)GalogenGetProcAddress("glBufferSubData");
   _glptr_glBufferSubData(target, offset, size, data);
}
PFN_glBufferSubData _glptr_glBufferSubData = _impl_glBufferSubData;

static void  GL_APIENTRY _impl_glGetQueryObjectuiv (GLuint id, GLenum pname, GLuint * params) {
  _glptr_glGetQueryObjectuiv = (PFN_glGetQueryObjectuiv)GalogenGetProcAddress("glGetQueryObjectuiv");
   _glptr_glGetQueryObjectuiv(id, pname, params);
}
PFN_glGetQueryObjectuiv _glptr_glGetQueryObjectuiv = _impl_glGetQueryObjectuiv;

static void  GL_APIENTRY _impl_glGetQueryObjectiv (GLuint id, GLenum pname, GLint * params) {
  _glptr_glGetQueryObjectiv = (PFN_glGetQueryObjectiv)GalogenGetProcAddress("glGetQueryObjectiv");
   _glptr_glGetQueryObjectiv(id, pname, params);
}
PFN_glGetQueryObjectiv _glptr_glGetQueryObjectiv = _impl_glGetQueryObjectiv;

static GLboolean GL_APIENTRY _impl_glIsQuery (GLuint id) {
  _glptr_glIsQuery = (PFN_glIsQuery)GalogenGetProcAddress("glIsQuery");
  return _glptr_glIsQuery(id);
}
PFN_glIsQuery _glptr_glIsQuery = _impl_glIsQuery;

static void  GL_APIENTRY _impl_glDeleteQueries (GLsizei n, const GLuint * ids) {
  _glptr_glDeleteQueries = (PFN_glDeleteQueries)GalogenGetProcAddress("glDeleteQueries");
   _glptr_glDeleteQueries(n, ids);
}
PFN_glDeleteQueries _glptr_glDeleteQueries = _impl_glDeleteQueries;

static void  GL_APIENTRY _impl_glGenQueries (GLsizei n, GLuint * ids) {
  _glptr_glGenQueries = (PFN_glGenQueries)GalogenGetProcAddress("glGenQueries");
   _glptr_glGenQueries(n, ids);
}
PFN_glGenQueries _glptr_glGenQueries = _impl_glGenQueries;

static void  GL_APIENTRY _impl_glBlendEquation (GLenum mode) {
  _glptr_glBlendEquation = (PFN_glBlendEquation)GalogenGetProcAddress("glBlendEquation");
   _glptr_glBlendEquation(mode);
}
PFN_glBlendEquation _glptr_glBlendEquation = _impl_glBlendEquation;

static void  GL_APIENTRY _impl_glVertexAttrib3sv (GLuint index, const GLshort * v) {
  _glptr_glVertexAttrib3sv = (PFN_glVertexAttrib3sv)GalogenGetProcAddress("glVertexAttrib3sv");
   _glptr_glVertexAttrib3sv(index, v);
}
PFN_glVertexAttrib3sv _glptr_glVertexAttrib3sv = _impl_glVertexAttrib3sv;

static void  GL_APIENTRY _impl_glVertexAttribI3ui (GLuint index, GLuint x, GLuint y, GLuint z) {
  _glptr_glVertexAttribI3ui = (PFN_glVertexAttribI3ui)GalogenGetProcAddress("glVertexAttribI3ui");
   _glptr_glVertexAttribI3ui(index, x, y, z);
}
PFN_glVertexAttribI3ui _glptr_glVertexAttribI3ui = _impl_glVertexAttribI3ui;

static void  GL_APIENTRY _impl_glGenBuffers (GLsizei n, GLuint * buffers) {
  _glptr_glGenBuffers = (PFN_glGenBuffers)GalogenGetProcAddress("glGenBuffers");
   _glptr_glGenBuffers(n, buffers);
}
PFN_glGenBuffers _glptr_glGenBuffers = _impl_glGenBuffers;

static GLenum GL_APIENTRY _impl_glCheckFramebufferStatus (GLenum target) {
  _glptr_glCheckFramebufferStatus = (PFN_glCheckFramebufferStatus)GalogenGetProcAddress("glCheckFramebufferStatus");
  return _glptr_glCheckFramebufferStatus(target);
}
PFN_glCheckFramebufferStatus _glptr_glCheckFramebufferStatus = _impl_glCheckFramebufferStatus;

static void  GL_APIENTRY _impl_glUniform4i (GLint location, GLint v0, GLint v1, GLint v2, GLint v3) {
  _glptr_glUniform4i = (PFN_glUniform4i)GalogenGetProcAddress("glUniform4i");
   _glptr_glUniform4i(location, v0, v1, v2, v3);
}
PFN_glUniform4i _glptr_glUniform4i = _impl_glUniform4i;

static void  GL_APIENTRY _impl_glPointParameteriv (GLenum pname, const GLint * params) {
  _glptr_glPointParameteriv = (PFN_glPointParameteriv)GalogenGetProcAddress("glPointParameteriv");
   _glptr_glPointParameteriv(pname, params);
}
PFN_glPointParameteriv _glptr_glPointParameteriv = _impl_glPointParameteriv;

static void  GL_APIENTRY _impl_glVertexAttrib2s (GLuint index, GLshort x, GLshort y) {
  _glptr_glVertexAttrib2s = (PFN_glVertexAttrib2s)GalogenGetProcAddress("glVertexAttrib2s");
   _glptr_glVertexAttrib2s(index, x, y);
}
PFN_glVertexAttrib2s _glptr_glVertexAttrib2s = _impl_glVertexAttrib2s;

static void  GL_APIENTRY _impl_glFinish () {
  _glptr_glFinish = (PFN_glFinish)GalogenGetProcAddress("glFinish");
   _glptr_glFinish();
}
PFN_glFinish _glptr_glFinish = _impl_glFinish;

static void  GL_APIENTRY _impl_glPointParameteri (GLenum pname, GLint param) {
  _glptr_glPointParameteri = (PFN_glPointParameteri)GalogenGetProcAddress("glPointParameteri");
   _glptr_glPointParameteri(pname, param);
}
PFN_glPointParameteri _glptr_glPointParameteri = _impl_glPointParameteri;

static void  GL_APIENTRY _impl_glMultiDrawArrays (GLenum mode, const GLint * first, const GLsizei * count, GLsizei drawcount) {
  _glptr_glMultiDrawArrays = (PFN_glMultiDrawArrays)GalogenGetProcAddress("glMultiDrawArrays");
   _glptr_glMultiDrawArrays(mode, first, count, drawcount);
}
PFN_glMultiDrawArrays _glptr_glMultiDrawArrays = _impl_glMultiDrawArrays;

static void  GL_APIENTRY _impl_glFramebufferRenderbuffer (GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer) {
  _glptr_glFramebufferRenderbuffer = (PFN_glFramebufferRenderbuffer)GalogenGetProcAddress("glFramebufferRenderbuffer");
   _glptr_glFramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
}
PFN_glFramebufferRenderbuffer _glptr_glFramebufferRenderbuffer = _impl_glFramebufferRenderbuffer;

static GLint GL_APIENTRY _impl_glGetFragDataIndex (GLuint program, const GLchar * name) {
  _glptr_glGetFragDataIndex = (PFN_glGetFragDataIndex)GalogenGetProcAddress("glGetFragDataIndex");
  return _glptr_glGetFragDataIndex(program, name);
}
PFN_glGetFragDataIndex _glptr_glGetFragDataIndex = _impl_glGetFragDataIndex;

static void  GL_APIENTRY _impl_glGetQueryiv (GLenum target, GLenum pname, GLint * params) {
  _glptr_glGetQueryiv = (PFN_glGetQueryiv)GalogenGetProcAddress("glGetQueryiv");
   _glptr_glGetQueryiv(target, pname, params);
}
PFN_glGetQueryiv _glptr_glGetQueryiv = _impl_glGetQueryiv;

static void  GL_APIENTRY _impl_glGetUniformfv (GLuint program, GLint location, GLfloat * params) {
  _glptr_glGetUniformfv = (PFN_glGetUniformfv)GalogenGetProcAddress("glGetUniformfv");
   _glptr_glGetUniformfv(program, location, params);
}
PFN_glGetUniformfv _glptr_glGetUniformfv = _impl_glGetUniformfv;

static void  GL_APIENTRY _impl_glVertexAttrib4usv (GLuint index, const GLushort * v) {
  _glptr_glVertexAttrib4usv = (PFN_glVertexAttrib4usv)GalogenGetProcAddress("glVertexAttrib4usv");
   _glptr_glVertexAttrib4usv(index, v);
}
PFN_glVertexAttrib4usv _glptr_glVertexAttrib4usv = _impl_glVertexAttrib4usv;

static void  GL_APIENTRY _impl_glDeleteSync (GLsync sync) {
  _glptr_glDeleteSync = (PFN_glDeleteSync)GalogenGetProcAddress("glDeleteSync");
   _glptr_glDeleteSync(sync);
}
PFN_glDeleteSync _glptr_glDeleteSync = _impl_glDeleteSync;

static void  GL_APIENTRY _impl_glGetCompressedTexImage (GLenum target, GLint level, void * img) {
  _glptr_glGetCompressedTexImage = (PFN_glGetCompressedTexImage)GalogenGetProcAddress("glGetCompressedTexImage");
   _glptr_glGetCompressedTexImage(target, level, img);
}
PFN_glGetCompressedTexImage _glptr_glGetCompressedTexImage = _impl_glGetCompressedTexImage;

static void  GL_APIENTRY _impl_glCompressedTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void * data) {
  _glptr_glCompressedTexSubImage2D = (PFN_glCompressedTexSubImage2D)GalogenGetProcAddress("glCompressedTexSubImage2D");
   _glptr_glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
}
PFN_glCompressedTexSubImage2D _glptr_glCompressedTexSubImage2D = _impl_glCompressedTexSubImage2D;

static void  GL_APIENTRY _impl_glUniform4ui (GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3) {
  _glptr_glUniform4ui = (PFN_glUniform4ui)GalogenGetProcAddress("glUniform4ui");
   _glptr_glUniform4ui(location, v0, v1, v2, v3);
}
PFN_glUniform4ui _glptr_glUniform4ui = _impl_glUniform4ui;

static void  GL_APIENTRY _impl_glVertexAttribI4usv (GLuint index, const GLushort * v) {
  _glptr_glVertexAttribI4usv = (PFN_glVertexAttribI4usv)GalogenGetProcAddress("glVertexAttribI4usv");
   _glptr_glVertexAttribI4usv(index, v);
}
PFN_glVertexAttribI4usv _glptr_glVertexAttribI4usv = _impl_glVertexAttribI4usv;

static void  GL_APIENTRY _impl_glCompressedTexImage2D (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void * data) {
  _glptr_glCompressedTexImage2D = (PFN_glCompressedTexImage2D)GalogenGetProcAddress("glCompressedTexImage2D");
   _glptr_glCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
}
PFN_glCompressedTexImage2D _glptr_glCompressedTexImage2D = _impl_glCompressedTexImage2D;

static void  GL_APIENTRY _impl_glCompressedTexImage3D (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void * data) {
  _glptr_glCompressedTexImage3D = (PFN_glCompressedTexImage3D)GalogenGetProcAddress("glCompressedTexImage3D");
   _glptr_glCompressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, data);
}
PFN_glCompressedTexImage3D _glptr_glCompressedTexImage3D = _impl_glCompressedTexImage3D;

static void  GL_APIENTRY _impl_glSampleCoverage (GLfloat value, GLboolean invert) {
  _glptr_glSampleCoverage = (PFN_glSampleCoverage)GalogenGetProcAddress("glSampleCoverage");
   _glptr_glSampleCoverage(value, invert);
}
PFN_glSampleCoverage _glptr_glSampleCoverage = _impl_glSampleCoverage;

static void  GL_APIENTRY _impl_glActiveTexture (GLenum texture) {
  _glptr_glActiveTexture = (PFN_glActiveTexture)GalogenGetProcAddress("glActiveTexture");
   _glptr_glActiveTexture(texture);
}
PFN_glActiveTexture _glptr_glActiveTexture = _impl_glActiveTexture;

static void  GL_APIENTRY _impl_glCopyTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
  _glptr_glCopyTexSubImage3D = (PFN_glCopyTexSubImage3D)GalogenGetProcAddress("glCopyTexSubImage3D");
   _glptr_glCopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);
}
PFN_glCopyTexSubImage3D _glptr_glCopyTexSubImage3D = _impl_glCopyTexSubImage3D;

static void  GL_APIENTRY _impl_glCompressedTexImage1D (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void * data) {
  _glptr_glCompressedTexImage1D = (PFN_glCompressedTexImage1D)GalogenGetProcAddress("glCompressedTexImage1D");
   _glptr_glCompressedTexImage1D(target, level, internalformat, width, border, imageSize, data);
}
PFN_glCompressedTexImage1D _glptr_glCompressedTexImage1D = _impl_glCompressedTexImage1D;

static void  GL_APIENTRY _impl_glTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void * pixels) {
  _glptr_glTexSubImage3D = (PFN_glTexSubImage3D)GalogenGetProcAddress("glTexSubImage3D");
   _glptr_glTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
}
PFN_glTexSubImage3D _glptr_glTexSubImage3D = _impl_glTexSubImage3D;

static void  GL_APIENTRY _impl_glUniformMatrix4fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
  _glptr_glUniformMatrix4fv = (PFN_glUniformMatrix4fv)GalogenGetProcAddress("glUniformMatrix4fv");
   _glptr_glUniformMatrix4fv(location, count, transpose, value);
}
PFN_glUniformMatrix4fv _glptr_glUniformMatrix4fv = _impl_glUniformMatrix4fv;

static const GLubyte * GL_APIENTRY _impl_glGetString (GLenum name) {
  _glptr_glGetString = (PFN_glGetString)GalogenGetProcAddress("glGetString");
  return _glptr_glGetString(name);
}
PFN_glGetString _glptr_glGetString = _impl_glGetString;

static void  GL_APIENTRY _impl_glRenderbufferStorage (GLenum target, GLenum internalformat, GLsizei width, GLsizei height) {
  _glptr_glRenderbufferStorage = (PFN_glRenderbufferStorage)GalogenGetProcAddress("glRenderbufferStorage");
   _glptr_glRenderbufferStorage(target, internalformat, width, height);
}
PFN_glRenderbufferStorage _glptr_glRenderbufferStorage = _impl_glRenderbufferStorage;

static GLboolean GL_APIENTRY _impl_glIsTexture (GLuint texture) {
  _glptr_glIsTexture = (PFN_glIsTexture)GalogenGetProcAddress("glIsTexture");
  return _glptr_glIsTexture(texture);
}
PFN_glIsTexture _glptr_glIsTexture = _impl_glIsTexture;

static void  GL_APIENTRY _impl_glGenTextures (GLsizei n, GLuint * textures) {
  _glptr_glGenTextures = (PFN_glGenTextures)GalogenGetProcAddress("glGenTextures");
   _glptr_glGenTextures(n, textures);
}
PFN_glGenTextures _glptr_glGenTextures = _impl_glGenTextures;

static void  GL_APIENTRY _impl_glVertexAttribP3ui (GLuint index, GLenum type, GLboolean normalized, GLuint value) {
  _glptr_glVertexAttribP3ui = (PFN_glVertexAttribP3ui)GalogenGetProcAddress("glVertexAttribP3ui");
   _glptr_glVertexAttribP3ui(index, type, normalized, value);
}
PFN_glVertexAttribP3ui _glptr_glVertexAttribP3ui = _impl_glVertexAttribP3ui;

static void  GL_APIENTRY _impl_glTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void * pixels) {
  _glptr_glTexSubImage1D = (PFN_glTexSubImage1D)GalogenGetProcAddress("glTexSubImage1D");
   _glptr_glTexSubImage1D(target, level, xoffset, width, format, type, pixels);
}
PFN_glTexSubImage1D _glptr_glTexSubImage1D = _impl_glTexSubImage1D;

static GLenum GL_APIENTRY _impl_glClientWaitSync (GLsync sync, GLbitfield flags, GLuint64 timeout) {
  _glptr_glClientWaitSync = (PFN_glClientWaitSync)GalogenGetProcAddress("glClientWaitSync");
  return _glptr_glClientWaitSync(sync, flags, timeout);
}
PFN_glClientWaitSync _glptr_glClientWaitSync = _impl_glClientWaitSync;

static void  GL_APIENTRY _impl_glCopyTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
  _glptr_glCopyTexSubImage2D = (PFN_glCopyTexSubImage2D)GalogenGetProcAddress("glCopyTexSubImage2D");
   _glptr_glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
}
PFN_glCopyTexSubImage2D _glptr_glCopyTexSubImage2D = _impl_glCopyTexSubImage2D;

static void  GL_APIENTRY _impl_glCopyTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width) {
  _glptr_glCopyTexSubImage1D = (PFN_glCopyTexSubImage1D)GalogenGetProcAddress("glCopyTexSubImage1D");
   _glptr_glCopyTexSubImage1D(target, level, xoffset, x, y, width);
}
PFN_glCopyTexSubImage1D _glptr_glCopyTexSubImage1D = _impl_glCopyTexSubImage1D;

static void  GL_APIENTRY _impl_glCopyTexImage1D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border) {
  _glptr_glCopyTexImage1D = (PFN_glCopyTexImage1D)GalogenGetProcAddress("glCopyTexImage1D");
   _glptr_glCopyTexImage1D(target, level, internalformat, x, y, width, border);
}
PFN_glCopyTexImage1D _glptr_glCopyTexImage1D = _impl_glCopyTexImage1D;

static void  GL_APIENTRY _impl_glPolygonOffset (GLfloat factor, GLfloat units) {
  _glptr_glPolygonOffset = (PFN_glPolygonOffset)GalogenGetProcAddress("glPolygonOffset");
   _glptr_glPolygonOffset(factor, units);
}
PFN_glPolygonOffset _glptr_glPolygonOffset = _impl_glPolygonOffset;

static void  GL_APIENTRY _impl_glTexImage2DMultisample (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations) {
  _glptr_glTexImage2DMultisample = (PFN_glTexImage2DMultisample)GalogenGetProcAddress("glTexImage2DMultisample");
   _glptr_glTexImage2DMultisample(target, samples, internalformat, width, height, fixedsamplelocations);
}
PFN_glTexImage2DMultisample _glptr_glTexImage2DMultisample = _impl_glTexImage2DMultisample;

static void  GL_APIENTRY _impl_glDrawElements (GLenum mode, GLsizei count, GLenum type, const void * indices) {
  _glptr_glDrawElements = (PFN_glDrawElements)GalogenGetProcAddress("glDrawElements");
   _glptr_glDrawElements(mode, count, type, indices);
}
PFN_glDrawElements _glptr_glDrawElements = _impl_glDrawElements;

static void  GL_APIENTRY _impl_glEndConditionalRender () {
  _glptr_glEndConditionalRender = (PFN_glEndConditionalRender)GalogenGetProcAddress("glEndConditionalRender");
   _glptr_glEndConditionalRender();
}
PFN_glEndConditionalRender _glptr_glEndConditionalRender = _impl_glEndConditionalRender;

static void  GL_APIENTRY _impl_glGetTransformFeedbackVarying (GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLsizei * size, GLenum * type, GLchar * name) {
  _glptr_glGetTransformFeedbackVarying = (PFN_glGetTransformFeedbackVarying)GalogenGetProcAddress("glGetTransformFeedbackVarying");
   _glptr_glGetTransformFeedbackVarying(program, index, bufSize, length, size, type, name);
}
PFN_glGetTransformFeedbackVarying _glptr_glGetTransformFeedbackVarying = _impl_glGetTransformFeedbackVarying;

static void  GL_APIENTRY _impl_glTexParameteriv (GLenum target, GLenum pname, const GLint * params) {
  _glptr_glTexParameteriv = (PFN_glTexParameteriv)GalogenGetProcAddress("glTexParameteriv");
   _glptr_glTexParameteriv(target, pname, params);
}
PFN_glTexParameteriv _glptr_glTexParameteriv = _impl_glTexParameteriv;

static void  GL_APIENTRY _impl_glDeleteFramebuffers (GLsizei n, const GLuint * framebuffers) {
  _glptr_glDeleteFramebuffers = (PFN_glDeleteFramebuffers)GalogenGetProcAddress("glDeleteFramebuffers");
   _glptr_glDeleteFramebuffers(n, framebuffers);
}
PFN_glDeleteFramebuffers _glptr_glDeleteFramebuffers = _impl_glDeleteFramebuffers;

static void  GL_APIENTRY _impl_glBlendEquationSeparate (GLenum modeRGB, GLenum modeAlpha) {
  _glptr_glBlendEquationSeparate = (PFN_glBlendEquationSeparate)GalogenGetProcAddress("glBlendEquationSeparate");
   _glptr_glBlendEquationSeparate(modeRGB, modeAlpha);
}
PFN_glBlendEquationSeparate _glptr_glBlendEquationSeparate = _impl_glBlendEquationSeparate;

static void  GL_APIENTRY _impl_glDeleteTextures (GLsizei n, const GLuint * textures) {
  _glptr_glDeleteTextures = (PFN_glDeleteTextures)GalogenGetProcAddress("glDeleteTextures");
   _glptr_glDeleteTextures(n, textures);
}
PFN_glDeleteTextures _glptr_glDeleteTextures = _impl_glDeleteTextures;

static void  GL_APIENTRY _impl_glGetProgramiv (GLuint program, GLenum pname, GLint * params) {
  _glptr_glGetProgramiv = (PFN_glGetProgramiv)GalogenGetProcAddress("glGetProgramiv");
   _glptr_glGetProgramiv(program, pname, params);
}
PFN_glGetProgramiv _glptr_glGetProgramiv = _impl_glGetProgramiv;

static void  GL_APIENTRY _impl_glUniform1uiv (GLint location, GLsizei count, const GLuint * value) {
  _glptr_glUniform1uiv = (PFN_glUniform1uiv)GalogenGetProcAddress("glUniform1uiv");
   _glptr_glUniform1uiv(location, count, value);
}
PFN_glUniform1uiv _glptr_glUniform1uiv = _impl_glUniform1uiv;

static void  GL_APIENTRY _impl_glCopyTexImage2D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border) {
  _glptr_glCopyTexImage2D = (PFN_glCopyTexImage2D)GalogenGetProcAddress("glCopyTexImage2D");
   _glptr_glCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
}
PFN_glCopyTexImage2D _glptr_glCopyTexImage2D = _impl_glCopyTexImage2D;

static void  GL_APIENTRY _impl_glGetTexLevelParameterfv (GLenum target, GLint level, GLenum pname, GLfloat * params) {
  _glptr_glGetTexLevelParameterfv = (PFN_glGetTexLevelParameterfv)GalogenGetProcAddress("glGetTexLevelParameterfv");
   _glptr_glGetTexLevelParameterfv(target, level, pname, params);
}
PFN_glGetTexLevelParameterfv _glptr_glGetTexLevelParameterfv = _impl_glGetTexLevelParameterfv;

static void  GL_APIENTRY _impl_glSampleMaski (GLuint maskNumber, GLbitfield mask) {
  _glptr_glSampleMaski = (PFN_glSampleMaski)GalogenGetProcAddress("glSampleMaski");
   _glptr_glSampleMaski(maskNumber, mask);
}
PFN_glSampleMaski _glptr_glSampleMaski = _impl_glSampleMaski;

static void  GL_APIENTRY _impl_glBindTexture (GLenum target, GLuint texture) {
  _glptr_glBindTexture = (PFN_glBindTexture)GalogenGetProcAddress("glBindTexture");
   _glptr_glBindTexture(target, texture);
}
PFN_glBindTexture _glptr_glBindTexture = _impl_glBindTexture;

static void  GL_APIENTRY _impl_glGetActiveUniformBlockiv (GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint * params) {
  _glptr_glGetActiveUniformBlockiv = (PFN_glGetActiveUniformBlockiv)GalogenGetProcAddress("glGetActiveUniformBlockiv");
   _glptr_glGetActiveUniformBlockiv(program, uniformBlockIndex, pname, params);
}
PFN_glGetActiveUniformBlockiv _glptr_glGetActiveUniformBlockiv = _impl_glGetActiveUniformBlockiv;

static void  GL_APIENTRY _impl_glGetUniformuiv (GLuint program, GLint location, GLuint * params) {
  _glptr_glGetUniformuiv = (PFN_glGetUniformuiv)GalogenGetProcAddress("glGetUniformuiv");
   _glptr_glGetUniformuiv(program, location, params);
}
PFN_glGetUniformuiv _glptr_glGetUniformuiv = _impl_glGetUniformuiv;

static void  GL_APIENTRY _impl_glVertexAttrib4Nbv (GLuint index, const GLbyte * v) {
  _glptr_glVertexAttrib4Nbv = (PFN_glVertexAttrib4Nbv)GalogenGetProcAddress("glVertexAttrib4Nbv");
   _glptr_glVertexAttrib4Nbv(index, v);
}
PFN_glVertexAttrib4Nbv _glptr_glVertexAttrib4Nbv = _impl_glVertexAttrib4Nbv;

static void  GL_APIENTRY _impl_glTexImage3D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void * pixels) {
  _glptr_glTexImage3D = (PFN_glTexImage3D)GalogenGetProcAddress("glTexImage3D");
   _glptr_glTexImage3D(target, level, internalformat, width, height, depth, border, format, type, pixels);
}
PFN_glTexImage3D _glptr_glTexImage3D = _impl_glTexImage3D;

static void  GL_APIENTRY _impl_glQueryCounter (GLuint id, GLenum target) {
  _glptr_glQueryCounter = (PFN_glQueryCounter)GalogenGetProcAddress("glQueryCounter");
   _glptr_glQueryCounter(id, target);
}
PFN_glQueryCounter _glptr_glQueryCounter = _impl_glQueryCounter;

static void  GL_APIENTRY _impl_glVertexAttrib4f (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
  _glptr_glVertexAttrib4f = (PFN_glVertexAttrib4f)GalogenGetProcAddress("glVertexAttrib4f");
   _glptr_glVertexAttrib4f(index, x, y, z, w);
}
PFN_glVertexAttrib4f _glptr_glVertexAttrib4f = _impl_glVertexAttrib4f;

static void  GL_APIENTRY _impl_glUniform2ui (GLint location, GLuint v0, GLuint v1) {
  _glptr_glUniform2ui = (PFN_glUniform2ui)GalogenGetProcAddress("glUniform2ui");
   _glptr_glUniform2ui(location, v0, v1);
}
PFN_glUniform2ui _glptr_glUniform2ui = _impl_glUniform2ui;

static void  GL_APIENTRY _impl_glGetTexImage (GLenum target, GLint level, GLenum format, GLenum type, void * pixels) {
  _glptr_glGetTexImage = (PFN_glGetTexImage)GalogenGetProcAddress("glGetTexImage");
   _glptr_glGetTexImage(target, level, format, type, pixels);
}
PFN_glGetTexImage _glptr_glGetTexImage = _impl_glGetTexImage;

static void  GL_APIENTRY _impl_glGetTexParameterIuiv (GLenum target, GLenum pname, GLuint * params) {
  _glptr_glGetTexParameterIuiv = (PFN_glGetTexParameterIuiv)GalogenGetProcAddress("glGetTexParameterIuiv");
   _glptr_glGetTexParameterIuiv(target, pname, params);
}
PFN_glGetTexParameterIuiv _glptr_glGetTexParameterIuiv = _impl_glGetTexParameterIuiv;

static void  GL_APIENTRY _impl_glVertexAttrib4bv (GLuint index, const GLbyte * v) {
  _glptr_glVertexAttrib4bv = (PFN_glVertexAttrib4bv)GalogenGetProcAddress("glVertexAttrib4bv");
   _glptr_glVertexAttrib4bv(index, v);
}
PFN_glVertexAttrib4bv _glptr_glVertexAttrib4bv = _impl_glVertexAttrib4bv;

static void  GL_APIENTRY _impl_glUniform2uiv (GLint location, GLsizei count, const GLuint * value) {
  _glptr_glUniform2uiv = (PFN_glUniform2uiv)GalogenGetProcAddress("glUniform2uiv");
   _glptr_glUniform2uiv(location, count, value);
}
PFN_glUniform2uiv _glptr_glUniform2uiv = _impl_glUniform2uiv;

static void  GL_APIENTRY _impl_glGetShaderSource (GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * source) {
  _glptr_glGetShaderSource = (PFN_glGetShaderSource)GalogenGetProcAddress("glGetShaderSource");
   _glptr_glGetShaderSource(shader, bufSize, length, source);
}
PFN_glGetShaderSource _glptr_glGetShaderSource = _impl_glGetShaderSource;

static GLboolean GL_APIENTRY _impl_glIsBuffer (GLuint buffer) {
  _glptr_glIsBuffer = (PFN_glIsBuffer)GalogenGetProcAddress("glIsBuffer");
  return _glptr_glIsBuffer(buffer);
}
PFN_glIsBuffer _glptr_glIsBuffer = _impl_glIsBuffer;

static void  GL_APIENTRY _impl_glGetBufferPointerv (GLenum target, GLenum pname, void ** params) {
  _glptr_glGetBufferPointerv = (PFN_glGetBufferPointerv)GalogenGetProcAddress("glGetBufferPointerv");
   _glptr_glGetBufferPointerv(target, pname, params);
}
PFN_glGetBufferPointerv _glptr_glGetBufferPointerv = _impl_glGetBufferPointerv;

static void  GL_APIENTRY _impl_glPolygonMode (GLenum face, GLenum mode) {
  _glptr_glPolygonMode = (PFN_glPolygonMode)GalogenGetProcAddress("glPolygonMode");
   _glptr_glPolygonMode(face, mode);
}
PFN_glPolygonMode _glptr_glPolygonMode = _impl_glPolygonMode;

static void  GL_APIENTRY _impl_glBindAttribLocation (GLuint program, GLuint index, const GLchar * name) {
  _glptr_glBindAttribLocation = (PFN_glBindAttribLocation)GalogenGetProcAddress("glBindAttribLocation");
   _glptr_glBindAttribLocation(program, index, name);
}
PFN_glBindAttribLocation _glptr_glBindAttribLocation = _impl_glBindAttribLocation;

static void  GL_APIENTRY _impl_glDeleteSamplers (GLsizei count, const GLuint * samplers) {
  _glptr_glDeleteSamplers = (PFN_glDeleteSamplers)GalogenGetProcAddress("glDeleteSamplers");
   _glptr_glDeleteSamplers(count, samplers);
}
PFN_glDeleteSamplers _glptr_glDeleteSamplers = _impl_glDeleteSamplers;

static void  GL_APIENTRY _impl_glUniform2f (GLint location, GLfloat v0, GLfloat v1) {
  _glptr_glUniform2f = (PFN_glUniform2f)GalogenGetProcAddress("glUniform2f");
   _glptr_glUniform2f(location, v0, v1);
}
PFN_glUniform2f _glptr_glUniform2f = _impl_glUniform2f;

static void  GL_APIENTRY _impl_glPixelStoref (GLenum pname, GLfloat param) {
  _glptr_glPixelStoref = (PFN_glPixelStoref)GalogenGetProcAddress("glPixelStoref");
   _glptr_glPixelStoref(pname, param);
}
PFN_glPixelStoref _glptr_glPixelStoref = _impl_glPixelStoref;

static void  GL_APIENTRY _impl_glLogicOp (GLenum opcode) {
  _glptr_glLogicOp = (PFN_glLogicOp)GalogenGetProcAddress("glLogicOp");
   _glptr_glLogicOp(opcode);
}
PFN_glLogicOp _glptr_glLogicOp = _impl_glLogicOp;

static GLuint GL_APIENTRY _impl_glCreateShader (GLenum type) {
  _glptr_glCreateShader = (PFN_glCreateShader)GalogenGetProcAddress("glCreateShader");
  return _glptr_glCreateShader(type);
}
PFN_glCreateShader _glptr_glCreateShader = _impl_glCreateShader;

static void  GL_APIENTRY _impl_glTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void * pixels) {
  _glptr_glTexSubImage2D = (PFN_glTexSubImage2D)GalogenGetProcAddress("glTexSubImage2D");
   _glptr_glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
}
PFN_glTexSubImage2D _glptr_glTexSubImage2D = _impl_glTexSubImage2D;

static void  GL_APIENTRY _impl_glClearDepth (GLdouble depth) {
  _glptr_glClearDepth = (PFN_glClearDepth)GalogenGetProcAddress("glClearDepth");
   _glptr_glClearDepth(depth);
}
PFN_glClearDepth _glptr_glClearDepth = _impl_glClearDepth;

static void  GL_APIENTRY _impl_glGetBufferSubData (GLenum target, GLintptr offset, GLsizeiptr size, void * data) {
  _glptr_glGetBufferSubData = (PFN_glGetBufferSubData)GalogenGetProcAddress("glGetBufferSubData");
   _glptr_glGetBufferSubData(target, offset, size, data);
}
PFN_glGetBufferSubData _glptr_glGetBufferSubData = _impl_glGetBufferSubData;

static void  GL_APIENTRY _impl_glVertexAttrib4uiv (GLuint index, const GLuint * v) {
  _glptr_glVertexAttrib4uiv = (PFN_glVertexAttrib4uiv)GalogenGetProcAddress("glVertexAttrib4uiv");
   _glptr_glVertexAttrib4uiv(index, v);
}
PFN_glVertexAttrib4uiv _glptr_glVertexAttrib4uiv = _impl_glVertexAttrib4uiv;

static void  GL_APIENTRY _impl_glCopyBufferSubData (GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size) {
  _glptr_glCopyBufferSubData = (PFN_glCopyBufferSubData)GalogenGetProcAddress("glCopyBufferSubData");
   _glptr_glCopyBufferSubData(readTarget, writeTarget, readOffset, writeOffset, size);
}
PFN_glCopyBufferSubData _glptr_glCopyBufferSubData = _impl_glCopyBufferSubData;

static void  GL_APIENTRY _impl_glFramebufferTexture2D (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) {
  _glptr_glFramebufferTexture2D = (PFN_glFramebufferTexture2D)GalogenGetProcAddress("glFramebufferTexture2D");
   _glptr_glFramebufferTexture2D(target, attachment, textarget, texture, level);
}
PFN_glFramebufferTexture2D _glptr_glFramebufferTexture2D = _impl_glFramebufferTexture2D;

static void  GL_APIENTRY _impl_glPointParameterf (GLenum pname, GLfloat param) {
  _glptr_glPointParameterf = (PFN_glPointParameterf)GalogenGetProcAddress("glPointParameterf");
   _glptr_glPointParameterf(pname, param);
}
PFN_glPointParameterf _glptr_glPointParameterf = _impl_glPointParameterf;

static void  GL_APIENTRY _impl_glDisablei (GLenum target, GLuint index) {
  _glptr_glDisablei = (PFN_glDisablei)GalogenGetProcAddress("glDisablei");
   _glptr_glDisablei(target, index);
}
PFN_glDisablei _glptr_glDisablei = _impl_glDisablei;

static void  GL_APIENTRY _impl_glUniformMatrix4x2fv (GLint location, GLsizei count, GLboolean transpose, const GLfloat * value) {
  _glptr_glUniformMatrix4x2fv = (PFN_glUniformMatrix4x2fv)GalogenGetProcAddress("glUniformMatrix4x2fv");
   _glptr_glUniformMatrix4x2fv(location, count, transpose, value);
}
PFN_glUniformMatrix4x2fv _glptr_glUniformMatrix4x2fv = _impl_glUniformMatrix4x2fv;

static void  GL_APIENTRY _impl_glVertexAttrib4d (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
  _glptr_glVertexAttrib4d = (PFN_glVertexAttrib4d)GalogenGetProcAddress("glVertexAttrib4d");
   _glptr_glVertexAttrib4d(index, x, y, z, w);
}
PFN_glVertexAttrib4d _glptr_glVertexAttrib4d = _impl_glVertexAttrib4d;

static void  GL_APIENTRY _impl_glTexParameterIuiv (GLenum target, GLenum pname, const GLuint * params) {
  _glptr_glTexParameterIuiv = (PFN_glTexParameterIuiv)GalogenGetProcAddress("glTexParameterIuiv");
   _glptr_glTexParameterIuiv(target, pname, params);
}
PFN_glTexParameterIuiv _glptr_glTexParameterIuiv = _impl_glTexParameterIuiv;

static void  GL_APIENTRY _impl_glGetFloatv (GLenum pname, GLfloat * data) {
  _glptr_glGetFloatv = (PFN_glGetFloatv)GalogenGetProcAddress("glGetFloatv");
   _glptr_glGetFloatv(pname, data);
}
PFN_glGetFloatv _glptr_glGetFloatv = _impl_glGetFloatv;

static GLuint GL_APIENTRY _impl_glCreateProgram () {
  _glptr_glCreateProgram = (PFN_glCreateProgram)GalogenGetProcAddress("glCreateProgram");
  return _glptr_glCreateProgram();
}
PFN_glCreateProgram _glptr_glCreateProgram = _impl_glCreateProgram;

static void  GL_APIENTRY _impl_glTransformFeedbackVaryings (GLuint program, GLsizei count, const GLchar *const* varyings, GLenum bufferMode) {
  _glptr_glTransformFeedbackVaryings = (PFN_glTransformFeedbackVaryings)GalogenGetProcAddress("glTransformFeedbackVaryings");
   _glptr_glTransformFeedbackVaryings(program, count, varyings, bufferMode);
}
PFN_glTransformFeedbackVaryings _glptr_glTransformFeedbackVaryings = _impl_glTransformFeedbackVaryings;

static void  GL_APIENTRY _impl_glVertexAttrib1d (GLuint index, GLdouble x) {
  _glptr_glVertexAttrib1d = (PFN_glVertexAttrib1d)GalogenGetProcAddress("glVertexAttrib1d");
   _glptr_glVertexAttrib1d(index, x);
}
PFN_glVertexAttrib1d _glptr_glVertexAttrib1d = _impl_glVertexAttrib1d;

static void  GL_APIENTRY _impl_glViewport (GLint x, GLint y, GLsizei width, GLsizei height) {
  _glptr_glViewport = (PFN_glViewport)GalogenGetProcAddress("glViewport");
   _glptr_glViewport(x, y, width, height);
}
PFN_glViewport _glptr_glViewport = _impl_glViewport;

static void  GL_APIENTRY _impl_glDeleteBuffers (GLsizei n, const GLuint * buffers) {
  _glptr_glDeleteBuffers = (PFN_glDeleteBuffers)GalogenGetProcAddress("glDeleteBuffers");
   _glptr_glDeleteBuffers(n, buffers);
}
PFN_glDeleteBuffers _glptr_glDeleteBuffers = _impl_glDeleteBuffers;

static void  GL_APIENTRY _impl_glFlush () {
  _glptr_glFlush = (PFN_glFlush)GalogenGetProcAddress("glFlush");
   _glptr_glFlush();
}
PFN_glFlush _glptr_glFlush = _impl_glFlush;

static void  GL_APIENTRY _impl_glVertexAttribI4sv (GLuint index, const GLshort * v) {
  _glptr_glVertexAttribI4sv = (PFN_glVertexAttribI4sv)GalogenGetProcAddress("glVertexAttribI4sv");
   _glptr_glVertexAttribI4sv(index, v);
}
PFN_glVertexAttribI4sv _glptr_glVertexAttribI4sv = _impl_glVertexAttribI4sv;

static void  GL_APIENTRY _impl_glDrawArrays (GLenum mode, GLint first, GLsizei count) {
  _glptr_glDrawArrays = (PFN_glDrawArrays)GalogenGetProcAddress("glDrawArrays");
   _glptr_glDrawArrays(mode, first, count);
}
PFN_glDrawArrays _glptr_glDrawArrays = _impl_glDrawArrays;

static void  GL_APIENTRY _impl_glDrawElementsInstanced (GLenum mode, GLsizei count, GLenum type, const void * indices, GLsizei instancecount) {
  _glptr_glDrawElementsInstanced = (PFN_glDrawElementsInstanced)GalogenGetProcAddress("glDrawElementsInstanced");
   _glptr_glDrawElementsInstanced(mode, count, type, indices, instancecount);
}
PFN_glDrawElementsInstanced _glptr_glDrawElementsInstanced = _impl_glDrawElementsInstanced;

static void  GL_APIENTRY _impl_glUniform3iv (GLint location, GLsizei count, const GLint * value) {
  _glptr_glUniform3iv = (PFN_glUniform3iv)GalogenGetProcAddress("glUniform3iv");
   _glptr_glUniform3iv(location, count, value);
}
PFN_glUniform3iv _glptr_glUniform3iv = _impl_glUniform3iv;

static void  GL_APIENTRY _impl_glVertexAttribPointer (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void * pointer) {
  _glptr_glVertexAttribPointer = (PFN_glVertexAttribPointer)GalogenGetProcAddress("glVertexAttribPointer");
   _glptr_glVertexAttribPointer(index, size, type, normalized, stride, pointer);
}
PFN_glVertexAttribPointer _glptr_glVertexAttribPointer = _impl_glVertexAttribPointer;

static void  GL_APIENTRY _impl_glGetSynciv (GLsync sync, GLenum pname, GLsizei bufSize, GLsizei * length, GLint * values) {
  _glptr_glGetSynciv = (PFN_glGetSynciv)GalogenGetProcAddress("glGetSynciv");
   _glptr_glGetSynciv(sync, pname, bufSize, length, values);
}
PFN_glGetSynciv _glptr_glGetSynciv = _impl_glGetSynciv;

static void  GL_APIENTRY _impl_glPrimitiveRestartIndex (GLuint index) {
  _glptr_glPrimitiveRestartIndex = (PFN_glPrimitiveRestartIndex)GalogenGetProcAddress("glPrimitiveRestartIndex");
   _glptr_glPrimitiveRestartIndex(index);
}
PFN_glPrimitiveRestartIndex _glptr_glPrimitiveRestartIndex = _impl_glPrimitiveRestartIndex;

static void  GL_APIENTRY _impl_glUniform1i (GLint location, GLint v0) {
  _glptr_glUniform1i = (PFN_glUniform1i)GalogenGetProcAddress("glUniform1i");
   _glptr_glUniform1i(location, v0);
}
PFN_glUniform1i _glptr_glUniform1i = _impl_glUniform1i;

static void  GL_APIENTRY _impl_glVertexAttrib1sv (GLuint index, const GLshort * v) {
  _glptr_glVertexAttrib1sv = (PFN_glVertexAttrib1sv)GalogenGetProcAddress("glVertexAttrib1sv");
   _glptr_glVertexAttrib1sv(index, v);
}
PFN_glVertexAttrib1sv _glptr_glVertexAttrib1sv = _impl_glVertexAttrib1sv;

static void  GL_APIENTRY _impl_glDisable (GLenum cap) {
  _glptr_glDisable = (PFN_glDisable)GalogenGetProcAddress("glDisable");
   _glptr_glDisable(cap);
}
PFN_glDisable _glptr_glDisable = _impl_glDisable;

static void  GL_APIENTRY _impl_glVertexAttribI4uiv (GLuint index, const GLuint * v) {
  _glptr_glVertexAttribI4uiv = (PFN_glVertexAttribI4uiv)GalogenGetProcAddress("glVertexAttribI4uiv");
   _glptr_glVertexAttribI4uiv(index, v);
}
PFN_glVertexAttribI4uiv _glptr_glVertexAttribI4uiv = _impl_glVertexAttribI4uiv;

static void  GL_APIENTRY _impl_glEndQuery (GLenum target) {
  _glptr_glEndQuery = (PFN_glEndQuery)GalogenGetProcAddress("glEndQuery");
   _glptr_glEndQuery(target);
}
PFN_glEndQuery _glptr_glEndQuery = _impl_glEndQuery;

static void  GL_APIENTRY _impl_glColorMask (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha) {
  _glptr_glColorMask = (PFN_glColorMask)GalogenGetProcAddress("glColorMask");
   _glptr_glColorMask(red, green, blue, alpha);
}
PFN_glColorMask _glptr_glColorMask = _impl_glColorMask;

static void  GL_APIENTRY _impl_glEnablei (GLenum target, GLuint index) {
  _glptr_glEnablei = (PFN_glEnablei)GalogenGetProcAddress("glEnablei");
   _glptr_glEnablei(target, index);
}
PFN_glEnablei _glptr_glEnablei = _impl_glEnablei;

static void  GL_APIENTRY _impl_glBindBuffer (GLenum target, GLuint buffer) {
  _glptr_glBindBuffer = (PFN_glBindBuffer)GalogenGetProcAddress("glBindBuffer");
   _glptr_glBindBuffer(target, buffer);
}
PFN_glBindBuffer _glptr_glBindBuffer = _impl_glBindBuffer;

static void  GL_APIENTRY _impl_glGetDoublev (GLenum pname, GLdouble * data) {
  _glptr_glGetDoublev = (PFN_glGetDoublev)GalogenGetProcAddress("glGetDoublev");
   _glptr_glGetDoublev(pname, data);
}
PFN_glGetDoublev _glptr_glGetDoublev = _impl_glGetDoublev;

static void  GL_APIENTRY _impl_glGetTexParameteriv (GLenum target, GLenum pname, GLint * params) {
  _glptr_glGetTexParameteriv = (PFN_glGetTexParameteriv)GalogenGetProcAddress("glGetTexParameteriv");
   _glptr_glGetTexParameteriv(target, pname, params);
}
PFN_glGetTexParameteriv _glptr_glGetTexParameteriv = _impl_glGetTexParameteriv;

static void  GL_APIENTRY _impl_glDeleteVertexArrays (GLsizei n, const GLuint * arrays) {
  _glptr_glDeleteVertexArrays = (PFN_glDeleteVertexArrays)GalogenGetProcAddress("glDeleteVertexArrays");
   _glptr_glDeleteVertexArrays(n, arrays);
}
PFN_glDeleteVertexArrays _glptr_glDeleteVertexArrays = _impl_glDeleteVertexArrays;

static void  GL_APIENTRY _impl_glVertexAttribI2uiv (GLuint index, const GLuint * v) {
  _glptr_glVertexAttribI2uiv = (PFN_glVertexAttribI2uiv)GalogenGetProcAddress("glVertexAttribI2uiv");
   _glptr_glVertexAttribI2uiv(index, v);
}
PFN_glVertexAttribI2uiv _glptr_glVertexAttribI2uiv = _impl_glVertexAttribI2uiv;

static void  GL_APIENTRY _impl_glDepthMask (GLboolean flag) {
  _glptr_glDepthMask = (PFN_glDepthMask)GalogenGetProcAddress("glDepthMask");
   _glptr_glDepthMask(flag);
}
PFN_glDepthMask _glptr_glDepthMask = _impl_glDepthMask;

static void  GL_APIENTRY _impl_glGetVertexAttribdv (GLuint index, GLenum pname, GLdouble * params) {
  _glptr_glGetVertexAttribdv = (PFN_glGetVertexAttribdv)GalogenGetProcAddress("glGetVertexAttribdv");
   _glptr_glGetVertexAttribdv(index, pname, params);
}
PFN_glGetVertexAttribdv _glptr_glGetVertexAttribdv = _impl_glGetVertexAttribdv;

static void  GL_APIENTRY _impl_glDrawRangeElements (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void * indices) {
  _glptr_glDrawRangeElements = (PFN_glDrawRangeElements)GalogenGetProcAddress("glDrawRangeElements");
   _glptr_glDrawRangeElements(mode, start, end, count, type, indices);
}
PFN_glDrawRangeElements _glptr_glDrawRangeElements = _impl_glDrawRangeElements;

static void  GL_APIENTRY _impl_glDrawArraysInstanced (GLenum mode, GLint first, GLsizei count, GLsizei instancecount) {
  _glptr_glDrawArraysInstanced = (PFN_glDrawArraysInstanced)GalogenGetProcAddress("glDrawArraysInstanced");
   _glptr_glDrawArraysInstanced(mode, first, count, instancecount);
}
PFN_glDrawArraysInstanced _glptr_glDrawArraysInstanced = _impl_glDrawArraysInstanced;

static void  GL_APIENTRY _impl_glGetSamplerParameterIiv (GLuint sampler, GLenum pname, GLint * params) {
  _glptr_glGetSamplerParameterIiv = (PFN_glGetSamplerParameterIiv)GalogenGetProcAddress("glGetSamplerParameterIiv");
   _glptr_glGetSamplerParameterIiv(sampler, pname, params);
}
PFN_glGetSamplerParameterIiv _glptr_glGetSamplerParameterIiv = _impl_glGetSamplerParameterIiv;

static void  GL_APIENTRY _impl_glClearStencil (GLint s) {
  _glptr_glClearStencil = (PFN_glClearStencil)GalogenGetProcAddress("glClearStencil");
   _glptr_glClearStencil(s);
}
PFN_glClearStencil _glptr_glClearStencil = _impl_glClearStencil;

static void  GL_APIENTRY _impl_glVertexAttribI3iv (GLuint index, const GLint * v) {
  _glptr_glVertexAttribI3iv = (PFN_glVertexAttribI3iv)GalogenGetProcAddress("glVertexAttribI3iv");
   _glptr_glVertexAttribI3iv(index, v);
}
PFN_glVertexAttribI3iv _glptr_glVertexAttribI3iv = _impl_glVertexAttribI3iv;

static void  GL_APIENTRY _impl_glDrawRangeElementsBaseVertex (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void * indices, GLint basevertex) {
  _glptr_glDrawRangeElementsBaseVertex = (PFN_glDrawRangeElementsBaseVertex)GalogenGetProcAddress("glDrawRangeElementsBaseVertex");
   _glptr_glDrawRangeElementsBaseVertex(mode, start, end, count, type, indices, basevertex);
}
PFN_glDrawRangeElementsBaseVertex _glptr_glDrawRangeElementsBaseVertex = _impl_glDrawRangeElementsBaseVertex;

static void  GL_APIENTRY _impl_glScissor (GLint x, GLint y, GLsizei width, GLsizei height) {
  _glptr_glScissor = (PFN_glScissor)GalogenGetProcAddress("glScissor");
   _glptr_glScissor(x, y, width, height);
}
PFN_glScissor _glptr_glScissor = _impl_glScissor;

static void  GL_APIENTRY _impl_glGenerateMipmap (GLenum target) {
  _glptr_glGenerateMipmap = (PFN_glGenerateMipmap)GalogenGetProcAddress("glGenerateMipmap");
   _glptr_glGenerateMipmap(target);
}
PFN_glGenerateMipmap _glptr_glGenerateMipmap = _impl_glGenerateMipmap;

static void  GL_APIENTRY _impl_glUniform3fv (GLint location, GLsizei count, const GLfloat * value) {
  _glptr_glUniform3fv = (PFN_glUniform3fv)GalogenGetProcAddress("glUniform3fv");
   _glptr_glUniform3fv(location, count, value);
}
PFN_glUniform3fv _glptr_glUniform3fv = _impl_glUniform3fv;

static void  GL_APIENTRY _impl_glUniform3uiv (GLint location, GLsizei count, const GLuint * value) {
  _glptr_glUniform3uiv = (PFN_glUniform3uiv)GalogenGetProcAddress("glUniform3uiv");
   _glptr_glUniform3uiv(location, count, value);
}
PFN_glUniform3uiv _glptr_glUniform3uiv = _impl_glUniform3uiv;

static void  GL_APIENTRY _impl_glClearBufferiv (GLenum buffer, GLint drawbuffer, const GLint * value) {
  _glptr_glClearBufferiv = (PFN_glClearBufferiv)GalogenGetProcAddress("glClearBufferiv");
   _glptr_glClearBufferiv(buffer, drawbuffer, value);
}
PFN_glClearBufferiv _glptr_glClearBufferiv = _impl_glClearBufferiv;

static void  GL_APIENTRY _impl_glVertexAttribI4ubv (GLuint index, const GLubyte * v) {
  _glptr_glVertexAttribI4ubv = (PFN_glVertexAttribI4ubv)GalogenGetProcAddress("glVertexAttribI4ubv");
   _glptr_glVertexAttribI4ubv(index, v);
}
PFN_glVertexAttribI4ubv _glptr_glVertexAttribI4ubv = _impl_glVertexAttribI4ubv;

static void  GL_APIENTRY _impl_glGetBooleanv (GLenum pname, GLboolean * data) {
  _glptr_glGetBooleanv = (PFN_glGetBooleanv)GalogenGetProcAddress("glGetBooleanv");
   _glptr_glGetBooleanv(pname, data);
}
PFN_glGetBooleanv _glptr_glGetBooleanv = _impl_glGetBooleanv;

static void  GL_APIENTRY _impl_glValidateProgram (GLuint program) {
  _glptr_glValidateProgram = (PFN_glValidateProgram)GalogenGetProcAddress("glValidateProgram");
   _glptr_glValidateProgram(program);
}
PFN_glValidateProgram _glptr_glValidateProgram = _impl_glValidateProgram;

static void  GL_APIENTRY _impl_glGenRenderbuffers (GLsizei n, GLuint * renderbuffers) {
  _glptr_glGenRenderbuffers = (PFN_glGenRenderbuffers)GalogenGetProcAddress("glGenRenderbuffers");
   _glptr_glGenRenderbuffers(n, renderbuffers);
}
PFN_glGenRenderbuffers _glptr_glGenRenderbuffers = _impl_glGenRenderbuffers;

static void  GL_APIENTRY _impl_glUniform2iv (GLint location, GLsizei count, const GLint * value) {
  _glptr_glUniform2iv = (PFN_glUniform2iv)GalogenGetProcAddress("glUniform2iv");
   _glptr_glUniform2iv(location, count, value);
}
PFN_glUniform2iv _glptr_glUniform2iv = _impl_glUniform2iv;

static void  GL_APIENTRY _impl_glBufferData (GLenum target, GLsizeiptr size, const void * data, GLenum usage) {
  _glptr_glBufferData = (PFN_glBufferData)GalogenGetProcAddress("glBufferData");
   _glptr_glBufferData(target, size, data, usage);
}
PFN_glBufferData _glptr_glBufferData = _impl_glBufferData;

static void  GL_APIENTRY _impl_glBlendFuncSeparate (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha) {
  _glptr_glBlendFuncSeparate = (PFN_glBlendFuncSeparate)GalogenGetProcAddress("glBlendFuncSeparate");
   _glptr_glBlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
}
PFN_glBlendFuncSeparate _glptr_glBlendFuncSeparate = _impl_glBlendFuncSeparate;

static void  GL_APIENTRY _impl_glTexParameteri (GLenum target, GLenum pname, GLint param) {
  _glptr_glTexParameteri = (PFN_glTexParameteri)GalogenGetProcAddress("glTexParameteri");
   _glptr_glTexParameteri(target, pname, param);
}
PFN_glTexParameteri _glptr_glTexParameteri = _impl_glTexParameteri;

static void  GL_APIENTRY _impl_glHint (GLenum target, GLenum mode) {
  _glptr_glHint = (PFN_glHint)GalogenGetProcAddress("glHint");
   _glptr_glHint(target, mode);
}
PFN_glHint _glptr_glHint = _impl_glHint;

static void  GL_APIENTRY _impl_glVertexAttrib3fv (GLuint index, const GLfloat * v) {
  _glptr_glVertexAttrib3fv = (PFN_glVertexAttrib3fv)GalogenGetProcAddress("glVertexAttrib3fv");
   _glptr_glVertexAttrib3fv(index, v);
}
PFN_glVertexAttrib3fv _glptr_glVertexAttrib3fv = _impl_glVertexAttrib3fv;

static void  GL_APIENTRY _impl_glGetSamplerParameteriv (GLuint sampler, GLenum pname, GLint * params) {
  _glptr_glGetSamplerParameteriv = (PFN_glGetSamplerParameteriv)GalogenGetProcAddress("glGetSamplerParameteriv");
   _glptr_glGetSamplerParameteriv(sampler, pname, params);
}
PFN_glGetSamplerParameteriv _glptr_glGetSamplerParameteriv = _impl_glGetSamplerParameteriv;

static void  GL_APIENTRY _impl_glDrawBuffer (GLenum buf) {
  _glptr_glDrawBuffer = (PFN_glDrawBuffer)GalogenGetProcAddress("glDrawBuffer");
   _glptr_glDrawBuffer(buf);
}
PFN_glDrawBuffer _glptr_glDrawBuffer = _impl_glDrawBuffer;

static GLboolean GL_APIENTRY _impl_glIsProgram (GLuint program) {
  _glptr_glIsProgram = (PFN_glIsProgram)GalogenGetProcAddress("glIsProgram");
  return _glptr_glIsProgram(program);
}
PFN_glIsProgram _glptr_glIsProgram = _impl_glIsProgram;

static void  GL_APIENTRY _impl_glGetIntegerv (GLenum pname, GLint * data) {
  _glptr_glGetIntegerv = (PFN_glGetIntegerv)GalogenGetProcAddress("glGetIntegerv");
   _glptr_glGetIntegerv(pname, data);
}
PFN_glGetIntegerv _glptr_glGetIntegerv = _impl_glGetIntegerv;

static void  GL_APIENTRY _impl_glDrawElementsBaseVertex (GLenum mode, GLsizei count, GLenum type, const void * indices, GLint basevertex) {
  _glptr_glDrawElementsBaseVertex = (PFN_glDrawElementsBaseVertex)GalogenGetProcAddress("glDrawElementsBaseVertex");
   _glptr_glDrawElementsBaseVertex(mode, count, type, indices, basevertex);
}
PFN_glDrawElementsBaseVertex _glptr_glDrawElementsBaseVertex = _impl_glDrawElementsBaseVertex;

static void  GL_APIENTRY _impl_glEnable (GLenum cap) {
  _glptr_glEnable = (PFN_glEnable)GalogenGetProcAddress("glEnable");
   _glptr_glEnable(cap);
}
PFN_glEnable _glptr_glEnable = _impl_glEnable;

static void  GL_APIENTRY _impl_glBlitFramebuffer (GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) {
  _glptr_glBlitFramebuffer = (PFN_glBlitFramebuffer)GalogenGetProcAddress("glBlitFramebuffer");
   _glptr_glBlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
}
PFN_glBlitFramebuffer _glptr_glBlitFramebuffer = _impl_glBlitFramebuffer;

static void  GL_APIENTRY _impl_glBeginQuery (GLenum target, GLuint id) {
  _glptr_glBeginQuery = (PFN_glBeginQuery)GalogenGetProcAddress("glBeginQuery");
   _glptr_glBeginQuery(target, id);
}
PFN_glBeginQuery _glptr_glBeginQuery = _impl_glBeginQuery;

static void  GL_APIENTRY _impl_glStencilMask (GLuint mask) {
  _glptr_glStencilMask = (PFN_glStencilMask)GalogenGetProcAddress("glStencilMask");
   _glptr_glStencilMask(mask);
}
PFN_glStencilMask _glptr_glStencilMask = _impl_glStencilMask;

static void  GL_APIENTRY _impl_glAttachShader (GLuint program, GLuint shader) {
  _glptr_glAttachShader = (PFN_glAttachShader)GalogenGetProcAddress("glAttachShader");
   _glptr_glAttachShader(program, shader);
}
PFN_glAttachShader _glptr_glAttachShader = _impl_glAttachShader;

static void  GL_APIENTRY _impl_glPointSize (GLfloat size) {
  _glptr_glPointSize = (PFN_glPointSize)GalogenGetProcAddress("glPointSize");
   _glptr_glPointSize(size);
}
PFN_glPointSize _glptr_glPointSize = _impl_glPointSize;

static void  GL_APIENTRY _impl_glMultiDrawElements (GLenum mode, const GLsizei * count, GLenum type, const void *const* indices, GLsizei drawcount) {
  _glptr_glMultiDrawElements = (PFN_glMultiDrawElements)GalogenGetProcAddress("glMultiDrawElements");
   _glptr_glMultiDrawElements(mode, count, type, indices, drawcount);
}
PFN_glMultiDrawElements _glptr_glMultiDrawElements = _impl_glMultiDrawElements;

static void  GL_APIENTRY _impl_glGetTexParameterfv (GLenum target, GLenum pname, GLfloat * params) {
  _glptr_glGetTexParameterfv = (PFN_glGetTexParameterfv)GalogenGetProcAddress("glGetTexParameterfv");
   _glptr_glGetTexParameterfv(target, pname, params);
}
PFN_glGetTexParameterfv _glptr_glGetTexParameterfv = _impl_glGetTexParameterfv;

static GLboolean GL_APIENTRY _impl_glIsEnabled (GLenum cap) {
  _glptr_glIsEnabled = (PFN_glIsEnabled)GalogenGetProcAddress("glIsEnabled");
  return _glptr_glIsEnabled(cap);
}
PFN_glIsEnabled _glptr_glIsEnabled = _impl_glIsEnabled;

static void  GL_APIENTRY _impl_glGetTexLevelParameteriv (GLenum target, GLint level, GLenum pname, GLint * params) {
  _glptr_glGetTexLevelParameteriv = (PFN_glGetTexLevelParameteriv)GalogenGetProcAddress("glGetTexLevelParameteriv");
   _glptr_glGetTexLevelParameteriv(target, level, pname, params);
}
PFN_glGetTexLevelParameteriv _glptr_glGetTexLevelParameteriv = _impl_glGetTexLevelParameteriv;

static GLenum GL_APIENTRY _impl_glGetError () {
  _glptr_glGetError = (PFN_glGetError)GalogenGetProcAddress("glGetError");
  return _glptr_glGetError();
}
PFN_glGetError _glptr_glGetError = _impl_glGetError;

static void  GL_APIENTRY _impl_glEndTransformFeedback () {
  _glptr_glEndTransformFeedback = (PFN_glEndTransformFeedback)GalogenGetProcAddress("glEndTransformFeedback");
   _glptr_glEndTransformFeedback();
}
PFN_glEndTransformFeedback _glptr_glEndTransformFeedback = _impl_glEndTransformFeedback;

static void  GL_APIENTRY _impl_glClearColor (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
  _glptr_glClearColor = (PFN_glClearColor)GalogenGetProcAddress("glClearColor");
   _glptr_glClearColor(red, green, blue, alpha);
}
PFN_glClearColor _glptr_glClearColor = _impl_glClearColor;

static void  GL_APIENTRY _impl_glBlendColor (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
  _glptr_glBlendColor = (PFN_glBlendColor)GalogenGetProcAddress("glBlendColor");
   _glptr_glBlendColor(red, green, blue, alpha);
}
PFN_glBlendColor _glptr_glBlendColor = _impl_glBlendColor;

static void  GL_APIENTRY _impl_glVertexAttribI3i (GLuint index, GLint x, GLint y, GLint z) {
  _glptr_glVertexAttribI3i = (PFN_glVertexAttribI3i)GalogenGetProcAddress("glVertexAttribI3i");
   _glptr_glVertexAttribI3i(index, x, y, z);
}
PFN_glVertexAttribI3i _glptr_glVertexAttribI3i = _impl_glVertexAttribI3i;

static void  GL_APIENTRY _impl_glCompressedTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void * data) {
  _glptr_glCompressedTexSubImage3D = (PFN_glCompressedTexSubImage3D)GalogenGetProcAddress("glCompressedTexSubImage3D");
   _glptr_glCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
}
PFN_glCompressedTexSubImage3D _glptr_glCompressedTexSubImage3D = _impl_glCompressedTexSubImage3D;

static void  GL_APIENTRY _impl_glReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, void * pixels) {
  _glptr_glReadPixels = (PFN_glReadPixels)GalogenGetProcAddress("glReadPixels");
   _glptr_glReadPixels(x, y, width, height, format, type, pixels);
}
PFN_glReadPixels _glptr_glReadPixels = _impl_glReadPixels;

static void  GL_APIENTRY _impl_glTexParameterf (GLenum target, GLenum pname, GLfloat param) {
  _glptr_glTexParameterf = (PFN_glTexParameterf)GalogenGetProcAddress("glTexParameterf");
   _glptr_glTexParameterf(target, pname, param);
}
PFN_glTexParameterf _glptr_glTexParameterf = _impl_glTexParameterf;

static void  GL_APIENTRY _impl_glSamplerParameterIiv (GLuint sampler, GLenum pname, const GLint * param) {
  _glptr_glSamplerParameterIiv = (PFN_glSamplerParameterIiv)GalogenGetProcAddress("glSamplerParameterIiv");
   _glptr_glSamplerParameterIiv(sampler, pname, param);
}
PFN_glSamplerParameterIiv _glptr_glSamplerParameterIiv = _impl_glSamplerParameterIiv;

static void  GL_APIENTRY _impl_glPointParameterfv (GLenum pname, const GLfloat * params) {
  _glptr_glPointParameterfv = (PFN_glPointParameterfv)GalogenGetProcAddress("glPointParameterfv");
   _glptr_glPointParameterfv(pname, params);
}
PFN_glPointParameterfv _glptr_glPointParameterfv = _impl_glPointParameterfv;

static void  GL_APIENTRY _impl_glGetShaderInfoLog (GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * infoLog) {
  _glptr_glGetShaderInfoLog = (PFN_glGetShaderInfoLog)GalogenGetProcAddress("glGetShaderInfoLog");
   _glptr_glGetShaderInfoLog(shader, bufSize, length, infoLog);
}
PFN_glGetShaderInfoLog _glptr_glGetShaderInfoLog = _impl_glGetShaderInfoLog;

static void  GL_APIENTRY _impl_glDepthFunc (GLenum func) {
  _glptr_glDepthFunc = (PFN_glDepthFunc)GalogenGetProcAddress("glDepthFunc");
   _glptr_glDepthFunc(func);
}
PFN_glDepthFunc _glptr_glDepthFunc = _impl_glDepthFunc;

static void  GL_APIENTRY _impl_glVertexAttribI3uiv (GLuint index, const GLuint * v) {
  _glptr_glVertexAttribI3uiv = (PFN_glVertexAttribI3uiv)GalogenGetProcAddress("glVertexAttribI3uiv");
   _glptr_glVertexAttribI3uiv(index, v);
}
PFN_glVertexAttribI3uiv _glptr_glVertexAttribI3uiv = _impl_glVertexAttribI3uiv;

static void  GL_APIENTRY _impl_glStencilOp (GLenum fail, GLenum zfail, GLenum zpass) {
  _glptr_glStencilOp = (PFN_glStencilOp)GalogenGetProcAddress("glStencilOp");
   _glptr_glStencilOp(fail, zfail, zpass);
}
PFN_glStencilOp _glptr_glStencilOp = _impl_glStencilOp;

static void  GL_APIENTRY _impl_glStencilFunc (GLenum func, GLint ref, GLuint mask) {
  _glptr_glStencilFunc = (PFN_glStencilFunc)GalogenGetProcAddress("glStencilFunc");
   _glptr_glStencilFunc(func, ref, mask);
}
PFN_glStencilFunc _glptr_glStencilFunc = _impl_glStencilFunc;

static void  GL_APIENTRY _impl_glEnableVertexAttribArray (GLuint index) {
  _glptr_glEnableVertexAttribArray = (PFN_glEnableVertexAttribArray)GalogenGetProcAddress("glEnableVertexAttribArray");
   _glptr_glEnableVertexAttribArray(index);
}
PFN_glEnableVertexAttribArray _glptr_glEnableVertexAttribArray = _impl_glEnableVertexAttribArray;

static void  GL_APIENTRY _impl_glBlendFunc (GLenum sfactor, GLenum dfactor) {
  _glptr_glBlendFunc = (PFN_glBlendFunc)GalogenGetProcAddress("glBlendFunc");
   _glptr_glBlendFunc(sfactor, dfactor);
}
PFN_glBlendFunc _glptr_glBlendFunc = _impl_glBlendFunc;

static void  GL_APIENTRY _impl_glVertexAttrib4Nub (GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) {
  _glptr_glVertexAttrib4Nub = (PFN_glVertexAttrib4Nub)GalogenGetProcAddress("glVertexAttrib4Nub");
   _glptr_glVertexAttrib4Nub(index, x, y, z, w);
}
PFN_glVertexAttrib4Nub _glptr_glVertexAttrib4Nub = _impl_glVertexAttrib4Nub;

static void  GL_APIENTRY _impl_glUniform1fv (GLint location, GLsizei count, const GLfloat * value) {
  _glptr_glUniform1fv = (PFN_glUniform1fv)GalogenGetProcAddress("glUniform1fv");
   _glptr_glUniform1fv(location, count, value);
}
PFN_glUniform1fv _glptr_glUniform1fv = _impl_glUniform1fv;

static void  GL_APIENTRY _impl_glPixelStorei (GLenum pname, GLint param) {
  _glptr_glPixelStorei = (PFN_glPixelStorei)GalogenGetProcAddress("glPixelStorei");
   _glptr_glPixelStorei(pname, param);
}
PFN_glPixelStorei _glptr_glPixelStorei = _impl_glPixelStorei;

static void  GL_APIENTRY _impl_glLineWidth (GLfloat width) {
  _glptr_glLineWidth = (PFN_glLineWidth)GalogenGetProcAddress("glLineWidth");
   _glptr_glLineWidth(width);
}
PFN_glLineWidth _glptr_glLineWidth = _impl_glLineWidth;

static void  GL_APIENTRY _impl_glVertexAttribP1ui (GLuint index, GLenum type, GLboolean normalized, GLuint value) {
  _glptr_glVertexAttribP1ui = (PFN_glVertexAttribP1ui)GalogenGetProcAddress("glVertexAttribP1ui");
   _glptr_glVertexAttribP1ui(index, type, normalized, value);
}
PFN_glVertexAttribP1ui _glptr_glVertexAttribP1ui = _impl_glVertexAttribP1ui;

static void  GL_APIENTRY _impl_glGetUniformiv (GLuint program, GLint location, GLint * params) {
  _glptr_glGetUniformiv = (PFN_glGetUniformiv)GalogenGetProcAddress("glGetUniformiv");
   _glptr_glGetUniformiv(program, location, params);
}
PFN_glGetUniformiv _glptr_glGetUniformiv = _impl_glGetUniformiv;

static void  GL_APIENTRY _impl_glReadBuffer (GLenum src) {
  _glptr_glReadBuffer = (PFN_glReadBuffer)GalogenGetProcAddress("glReadBuffer");
   _glptr_glReadBuffer(src);
}
PFN_glReadBuffer _glptr_glReadBuffer = _impl_glReadBuffer;

static void  GL_APIENTRY _impl_glTexImage1D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const void * pixels) {
  _glptr_glTexImage1D = (PFN_glTexImage1D)GalogenGetProcAddress("glTexImage1D");
   _glptr_glTexImage1D(target, level, internalformat, width, border, format, type, pixels);
}
PFN_glTexImage1D _glptr_glTexImage1D = _impl_glTexImage1D;

static void  GL_APIENTRY _impl_glTexParameterfv (GLenum target, GLenum pname, const GLfloat * params) {
  _glptr_glTexParameterfv = (PFN_glTexParameterfv)GalogenGetProcAddress("glTexParameterfv");
   _glptr_glTexParameterfv(target, pname, params);
}
PFN_glTexParameterfv _glptr_glTexParameterfv = _impl_glTexParameterfv;

static void  GL_APIENTRY _impl_glVertexAttrib3s (GLuint index, GLshort x, GLshort y, GLshort z) {
  _glptr_glVertexAttrib3s = (PFN_glVertexAttrib3s)GalogenGetProcAddress("glVertexAttrib3s");
   _glptr_glVertexAttrib3s(index, x, y, z);
}
PFN_glVertexAttrib3s _glptr_glVertexAttrib3s = _impl_glVertexAttrib3s;

static void  GL_APIENTRY _impl_glCompressedTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void * data) {
  _glptr_glCompressedTexSubImage1D = (PFN_glCompressedTexSubImage1D)GalogenGetProcAddress("glCompressedTexSubImage1D");
   _glptr_glCompressedTexSubImage1D(target, level, xoffset, width, format, imageSize, data);
}
PFN_glCompressedTexSubImage1D _glptr_glCompressedTexSubImage1D = _impl_glCompressedTexSubImage1D;

static void  GL_APIENTRY _impl_glClear (GLbitfield mask) {
  _glptr_glClear = (PFN_glClear)GalogenGetProcAddress("glClear");
   _glptr_glClear(mask);
}
PFN_glClear _glptr_glClear = _impl_glClear;

static void  GL_APIENTRY _impl_glTexImage2D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void * pixels) {
  _glptr_glTexImage2D = (PFN_glTexImage2D)GalogenGetProcAddress("glTexImage2D");
   _glptr_glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
}
PFN_glTexImage2D _glptr_glTexImage2D = _impl_glTexImage2D;

static void  GL_APIENTRY _impl_glVertexAttrib4Niv (GLuint index, const GLint * v) {
  _glptr_glVertexAttrib4Niv = (PFN_glVertexAttrib4Niv)GalogenGetProcAddress("glVertexAttrib4Niv");
   _glptr_glVertexAttrib4Niv(index, v);
}
PFN_glVertexAttrib4Niv _glptr_glVertexAttrib4Niv = _impl_glVertexAttrib4Niv;

static void  GL_APIENTRY _impl_glGetVertexAttribIuiv (GLuint index, GLenum pname, GLuint * params) {
  _glptr_glGetVertexAttribIuiv = (PFN_glGetVertexAttribIuiv)GalogenGetProcAddress("glGetVertexAttribIuiv");
   _glptr_glGetVertexAttribIuiv(index, pname, params);
}
PFN_glGetVertexAttribIuiv _glptr_glGetVertexAttribIuiv = _impl_glGetVertexAttribIuiv;

static void  GL_APIENTRY _impl_glStencilMaskSeparate (GLenum face, GLuint mask) {
  _glptr_glStencilMaskSeparate = (PFN_glStencilMaskSeparate)GalogenGetProcAddress("glStencilMaskSeparate");
   _glptr_glStencilMaskSeparate(face, mask);
}
PFN_glStencilMaskSeparate _glptr_glStencilMaskSeparate = _impl_glStencilMaskSeparate;

static void  GL_APIENTRY _impl_glGenVertexArrays (GLsizei n, GLuint * arrays) {
  _glptr_glGenVertexArrays = (PFN_glGenVertexArrays)GalogenGetProcAddress("glGenVertexArrays");
   _glptr_glGenVertexArrays(n, arrays);
}
PFN_glGenVertexArrays _glptr_glGenVertexArrays = _impl_glGenVertexArrays;

static void  GL_APIENTRY _impl_glFrontFace (GLenum mode) {
  _glptr_glFrontFace = (PFN_glFrontFace)GalogenGetProcAddress("glFrontFace");
   _glptr_glFrontFace(mode);
}
PFN_glFrontFace _glptr_glFrontFace = _impl_glFrontFace;

static void  GL_APIENTRY _impl_glDepthRange (GLdouble n, GLdouble f) {
  _glptr_glDepthRange = (PFN_glDepthRange)GalogenGetProcAddress("glDepthRange");
   _glptr_glDepthRange(n, f);
}
PFN_glDepthRange _glptr_glDepthRange = _impl_glDepthRange;

static void  GL_APIENTRY _impl_glVertexAttrib4s (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w) {
  _glptr_glVertexAttrib4s = (PFN_glVertexAttrib4s)GalogenGetProcAddress("glVertexAttrib4s");
   _glptr_glVertexAttrib4s(index, x, y, z, w);
}
PFN_glVertexAttrib4s _glptr_glVertexAttrib4s = _impl_glVertexAttrib4s;

static void  GL_APIENTRY _impl_glDetachShader (GLuint program, GLuint shader) {
  _glptr_glDetachShader = (PFN_glDetachShader)GalogenGetProcAddress("glDetachShader");
   _glptr_glDetachShader(program, shader);
}
PFN_glDetachShader _glptr_glDetachShader = _impl_glDetachShader;

static void  GL_APIENTRY _impl_glCullFace (GLenum mode) {
  _glptr_glCullFace = (PFN_glCullFace)GalogenGetProcAddress("glCullFace");
   _glptr_glCullFace(mode);
}
PFN_glCullFace _glptr_glCullFace = _impl_glCullFace;

